/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.util.Iterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.orm.jbt.api.wrp.ColumnWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ForeignKeyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.PrimaryKeyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TableWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ValueWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.ColumnWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.ForeignKeyWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.PrimaryKeyWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class TableWrapperFactory {
    public static TableWrapper createTableWrapper(String name) {
        Table t = new Table("Hibernate Tools", name);
        t.setPrimaryKey(new PrimaryKey(t));
        return TableWrapperFactory.createTableWrapper(t);
    }

    static TableWrapper createTableWrapper(Table wrappedTable) {
        return new TableWrapperImpl(wrappedTable);
    }

    private static class TableWrapperImpl
    extends AbstractWrapper
    implements TableWrapper {
        private Table table = null;

        private TableWrapperImpl(Table table) {
            this.table = table;
        }

        public Table getWrappedObject() {
            return this.table;
        }

        @Override
        public String getName() {
            return this.table.getName();
        }

        @Override
        public void addColumn(ColumnWrapper column) {
            this.table.addColumn((Column)column.getWrappedObject());
        }

        @Override
        public String getCatalog() {
            return this.table.getCatalog();
        }

        @Override
        public String getSchema() {
            return this.table.getSchema();
        }

        @Override
        public PrimaryKeyWrapper getPrimaryKey() {
            PrimaryKey pk = this.table.getPrimaryKey();
            return pk == null ? null : PrimaryKeyWrapperFactory.createPrimaryKeyWrapper(pk);
        }

        @Override
        public Iterator<ColumnWrapper> getColumnIterator() {
            final Iterator iterator = this.table.getColumns().iterator();
            return new Iterator<ColumnWrapper>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public ColumnWrapper next() {
                    return ColumnWrapperFactory.createColumnWrapper((Column)iterator.next());
                }
            };
        }

        @Override
        public Iterator<ForeignKeyWrapper> getForeignKeyIterator() {
            final Iterator iterator = this.table.getForeignKeys().values().iterator();
            return new Iterator<ForeignKeyWrapper>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public ForeignKeyWrapper next() {
                    return ForeignKeyWrapperFactory.createForeignKeyWrapper((ForeignKey)iterator.next());
                }
            };
        }

        @Override
        public String getComment() {
            return this.table.getComment();
        }

        @Override
        public String getRowId() {
            return this.table.getRowId();
        }

        @Override
        public String getSubselect() {
            return this.table.getSubselect();
        }

        @Override
        public boolean hasDenormalizedTables() {
            return this.table.hasDenormalizedTables();
        }

        @Override
        public boolean isAbstract() {
            return this.table.isAbstract();
        }

        @Override
        public boolean isAbstractUnionTable() {
            return this.table.isAbstractUnionTable();
        }

        @Override
        public boolean isPhysicalTable() {
            return this.table.isPhysicalTable();
        }

        @Override
        public ValueWrapper getIdentifierValue() {
            return null;
        }
    }
}

