/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.tool.orm.jbt.api.wrp.QueryWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.SessionFactoryWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.SessionWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.QueryWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.SessionFactoryWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class SessionWrapperFactory {
    public static SessionWrapper createSessionWrapper(Session wrappedSession) {
        return new SessionWrapperImpl(wrappedSession);
    }

    private static class SessionWrapperImpl
    extends AbstractWrapper
    implements SessionWrapper {
        private Session session = null;

        private SessionWrapperImpl(Session session) {
            this.session = session;
        }

        public Session getWrappedObject() {
            return this.session;
        }

        @Override
        public String getEntityName(Object o) {
            return this.session.getEntityName(o);
        }

        @Override
        public SessionFactoryWrapper getSessionFactory() {
            SessionFactory sf = this.session.getSessionFactory();
            return sf == null ? null : SessionFactoryWrapperFactory.createSessionFactoryWrapper(sf);
        }

        @Override
        public QueryWrapper createQuery(String s) {
            Query query = this.session.createQuery(s, null);
            return QueryWrapperFactory.createQueryWrapper(query);
        }

        @Override
        public boolean isOpen() {
            return this.session.isOpen();
        }

        @Override
        public void close() {
            this.session.close();
        }

        @Override
        public boolean contains(Object o) {
            boolean result;
            block2: {
                result = false;
                try {
                    result = this.session.contains(o);
                }
                catch (IllegalArgumentException e) {
                    String message = e.getMessage();
                    if (message.startsWith("Class '") && message.endsWith("' is not an entity class")) break block2;
                    throw e;
                }
            }
            return result;
        }

        @Override
        public QueryWrapper createCriteria(Class<?> c) {
            HibernateCriteriaBuilder criteriaBuilder = this.session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(c);
            criteriaQuery.select((Selection)criteriaQuery.from(c));
            Query query = this.getWrappedObject().createQuery(criteriaQuery);
            return QueryWrapperFactory.createQueryWrapper(query);
        }
    }
}

