/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import org.hibernate.cfg.Environment;
import org.hibernate.tool.orm.jbt.api.wrp.EnvironmentWrapper;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class EnvironmentWrapperFactory {
    static EnvironmentWrapper ENVIRONMENT_WRAPPER_INSTANCE = new EnvironmentWrapperImpl();

    public static EnvironmentWrapper createEnvironmentWrapper() {
        return ENVIRONMENT_WRAPPER_INSTANCE;
    }

    private static class EnvironmentWrapperImpl
    extends AbstractWrapper
    implements EnvironmentWrapper {
        private EnvironmentWrapperImpl() {
        }

        @Override
        public String getTransactionManagerStrategy() {
            return "hibernate.transaction.coordinator_class";
        }

        @Override
        public String getDriver() {
            return "jakarta.persistence.jdbc.driver";
        }

        @Override
        public String getHBM2DDLAuto() {
            return "hibernate.hbm2ddl.auto";
        }

        @Override
        public String getDialect() {
            return "hibernate.dialect";
        }

        @Override
        public String getDataSource() {
            return "jakarta.persistence.jtaDataSource";
        }

        @Override
        public String getConnectionProvider() {
            return "hibernate.connection.provider_class";
        }

        @Override
        public String getURL() {
            return "jakarta.persistence.jdbc.url";
        }

        @Override
        public String getUser() {
            return "jakarta.persistence.jdbc.user";
        }

        @Override
        public String getPass() {
            return "jakarta.persistence.jdbc.password";
        }

        @Override
        public String getSessionFactoryName() {
            return "hibernate.session_factory_name";
        }

        @Override
        public String getDefaultCatalog() {
            return "hibernate.default_catalog";
        }

        @Override
        public String getDefaultSchema() {
            return "hibernate.default_schema";
        }

        public Class<Environment> getWrappedClass() {
            return Environment.class;
        }
    }
}

