/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Value;
import org.hibernate.tool.orm.jbt.api.wrp.ColumnWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ConfigurationWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ValueWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.ValueWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.util.MetadataHelper;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class ColumnWrapperFactory {
    public static ColumnWrapper createColumnWrapper(String name) {
        return new ColumnWrapperImpl(name);
    }

    public static ColumnWrapper createColumnWrapper(Column column) {
        return new ColumnWrapperImpl(column);
    }

    private static class ColumnWrapperImpl
    extends AbstractWrapper
    implements ColumnWrapper {
        private Column wrappedColumn = null;
        private ValueWrapper valueWrapper = null;

        private ColumnWrapperImpl(Column column) {
            this.wrappedColumn = column;
        }

        private ColumnWrapperImpl(String name) {
            this.wrappedColumn = new Column(name);
        }

        public Column getWrappedObject() {
            return this.wrappedColumn;
        }

        @Override
        public String getName() {
            return this.wrappedColumn.getName();
        }

        @Override
        public Integer getSqlTypeCode() {
            return this.wrappedColumn.getSqlTypeCode();
        }

        @Override
        public String getSqlType() {
            return this.wrappedColumn.getSqlType();
        }

        @Override
        public String getSqlType(ConfigurationWrapper configurationWrapper) {
            return this.wrappedColumn.getSqlType(MetadataHelper.getMetadata((Configuration)configurationWrapper.getWrappedObject()));
        }

        @Override
        public long getLength() {
            Long length = this.wrappedColumn.getLength();
            return length == null ? Integer.MIN_VALUE : length;
        }

        @Override
        public int getDefaultLength() {
            return 255;
        }

        @Override
        public int getPrecision() {
            Integer precision = this.wrappedColumn.getPrecision();
            return precision == null ? Integer.MIN_VALUE : precision;
        }

        @Override
        public int getDefaultPrecision() {
            return 19;
        }

        @Override
        public int getScale() {
            Integer scale = this.wrappedColumn.getScale();
            return scale == null ? Integer.MIN_VALUE : scale;
        }

        @Override
        public int getDefaultScale() {
            return 2;
        }

        @Override
        public boolean isNullable() {
            return this.wrappedColumn.isNullable();
        }

        @Override
        public ValueWrapper getValue() {
            Value v = this.wrappedColumn.getValue();
            if (this.valueWrapper == null || this.valueWrapper.getWrappedObject() != v) {
                this.valueWrapper = v != null ? ValueWrapperFactory.createValueWrapper(v) : null;
            }
            return this.valueWrapper;
        }

        @Override
        public boolean isUnique() {
            return this.wrappedColumn.isUnique();
        }

        @Override
        public void setSqlType(String sqlType) {
            this.wrappedColumn.setSqlType(sqlType);
        }
    }
}

