/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.tool.orm.jbt.api.wrp.PersistentClassWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.PropertyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TypeWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ValueWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.PersistentClassWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.TypeWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.ValueWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;
import org.hibernate.type.Type;

public class PropertyWrapperFactory {
    public static PropertyWrapper createPropertyWrapper() {
        return PropertyWrapperFactory.createPropertyWrapper(new Property());
    }

    static PropertyWrapper createPropertyWrapper(Property wrappedProperty) {
        return new PropertyWrapperImpl(wrappedProperty);
    }

    private static class PropertyWrapperImpl
    extends AbstractWrapper
    implements PropertyWrapper {
        private Property property = null;

        private PropertyWrapperImpl(Property property) {
            this.property = property;
        }

        public Property getWrappedObject() {
            return this.property;
        }

        @Override
        public ValueWrapper getValue() {
            Value v = this.property.getValue();
            return v == null ? null : ValueWrapperFactory.createValueWrapper(v);
        }

        @Override
        public void setName(String name) {
            this.property.setName(name);
        }

        @Override
        public void setPersistentClass(PersistentClassWrapper pc) {
            this.property.setPersistentClass(pc == null ? null : (PersistentClass)pc.getWrappedObject());
        }

        @Override
        public PersistentClassWrapper getPersistentClass() {
            PersistentClass pc = this.property.getPersistentClass();
            return pc == null ? null : PersistentClassWrapperFactory.createPersistentClassWrapper(pc);
        }

        @Override
        public boolean isComposite() {
            return this.property.isComposite();
        }

        @Override
        public String getPropertyAccessorName() {
            return this.property.getPropertyAccessorName();
        }

        @Override
        public String getName() {
            return this.property.getName();
        }

        @Override
        public TypeWrapper getType() {
            Type t = null;
            Value v = this.getWrappedObject().getValue();
            if (v != null) {
                t = v.getType();
            }
            return t == null ? null : TypeWrapperFactory.createTypeWrapper(t);
        }

        @Override
        public void setValue(ValueWrapper value) {
            this.property.setValue(value == null ? null : (Value)value.getWrappedObject());
        }

        @Override
        public void setPropertyAccessorName(String s) {
            this.property.setPropertyAccessorName(s);
        }

        @Override
        public void setCascade(String s) {
            this.property.setCascade(s);
        }

        @Override
        public boolean isBackRef() {
            return this.property.isBackRef();
        }

        @Override
        public boolean isSelectable() {
            return this.property.isSelectable();
        }

        @Override
        public boolean isInsertable() {
            return this.property.isInsertable();
        }

        @Override
        public boolean isUpdateable() {
            return this.property.isUpdateable();
        }

        @Override
        public String getCascade() {
            return this.property.getCascade();
        }

        @Override
        public boolean isLazy() {
            return this.property.isLazy();
        }

        @Override
        public boolean isOptional() {
            return this.property.isOptional();
        }

        @Override
        public boolean isNaturalIdentifier() {
            return this.property.isNaturalIdentifier();
        }

        @Override
        public boolean isOptimisticLocked() {
            return this.property.isOptimisticLocked();
        }
    }
}

