/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.internal.export.hbm.HbmExporter;
import org.hibernate.tool.internal.export.java.POJOClass;
import org.hibernate.tool.orm.jbt.api.wrp.ConfigurationWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.HbmExporterWrapper;
import org.hibernate.tool.orm.jbt.internal.util.ConfigurationMetadataDescriptor;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class HbmExporterWrapperFactory {
    public static HbmExporterWrapper createHbmExporterWrapper(ConfigurationWrapper configurationWrapper, File file) {
        return HbmExporterWrapperFactory.createHbmExporterWrapper((Configuration)configurationWrapper.getWrappedObject(), file);
    }

    private static HbmExporterWrapper createHbmExporterWrapper(Configuration cfg, File f) {
        return new HbmExporterWrapperImpl(new HbmExporterExtension(cfg, f));
    }

    private static class HbmExporterWrapperImpl
    extends AbstractWrapper
    implements HbmExporterWrapper {
        private HbmExporterExtension hbmExporterExtension;

        private HbmExporterWrapperImpl(HbmExporterExtension hbmExporterExtension) {
            this.hbmExporterExtension = hbmExporterExtension;
        }

        public HbmExporter getWrappedObject() {
            return this.hbmExporterExtension;
        }

        @Override
        public void start() {
            this.hbmExporterExtension.start();
        }

        @Override
        public File getOutputDirectory() {
            return (File)this.hbmExporterExtension.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder");
        }

        @Override
        public void setOutputDirectory(File f) {
            this.hbmExporterExtension.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", f);
        }

        @Override
        public void exportPOJO(Map<Object, Object> map, Object pojoClass) {
            this.hbmExporterExtension.exportPOJO(map, (POJOClass)pojoClass);
        }

        @Override
        public void setExportPOJODelegate(Object delegate) {
            this.hbmExporterExtension.delegateExporter = delegate;
        }
    }

    public static class HbmExporterExtension
    extends HbmExporter {
        public Object delegateExporter = null;

        private HbmExporterExtension(Configuration cfg, File f) {
            this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", new ConfigurationMetadataDescriptor(cfg));
            if (f != null) {
                this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.OutputFileName", f);
            }
        }

        public void exportPOJO(Map map, POJOClass pojoClass) {
            if (this.delegateExporter == null) {
                super.exportPOJO(map, pojoClass);
            } else {
                this.delegateExporterExportPOJO(map, pojoClass, pojoClass.getQualifiedDeclarationName());
            }
        }

        private void delegateExporterExportPOJO(Map<Object, Object> map, POJOClass pojoClass, String qualifiedDeclarationName) {
            try {
                Method method = this.delegateExporter.getClass().getDeclaredMethod("exportPojo", Map.class, Object.class, String.class);
                method.setAccessible(true);
                method.invoke(this.delegateExporter, map, pojoClass, qualifiedDeclarationName);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

