/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.tool.orm.jbt.api.wrp.ColumnWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ForeignKeyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TableWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.ColumnWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.TableWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class ForeignKeyWrapperFactory {
    public static ForeignKeyWrapper createForeignKeyWrapper(ForeignKey wrappedForeignKey) {
        return new ForeignKeyWrapperImpl(wrappedForeignKey);
    }

    private static class ForeignKeyWrapperImpl
    extends AbstractWrapper
    implements ForeignKeyWrapper {
        private ForeignKey foreignKey = null;
        private List<ColumnWrapper> referencedColumns = null;

        private ForeignKeyWrapperImpl(ForeignKey foreignKey) {
            this.foreignKey = foreignKey;
        }

        public ForeignKey getWrappedObject() {
            return this.foreignKey;
        }

        @Override
        public TableWrapper getReferencedTable() {
            return TableWrapperFactory.createTableWrapper(this.foreignKey.getReferencedTable());
        }

        @Override
        public Iterator<ColumnWrapper> columnIterator() {
            final Iterator columnIterator = this.foreignKey.getColumns().iterator();
            return new Iterator<ColumnWrapper>(){

                @Override
                public boolean hasNext() {
                    return columnIterator.hasNext();
                }

                @Override
                public ColumnWrapper next() {
                    return ColumnWrapperFactory.createColumnWrapper((Column)columnIterator.next());
                }
            };
        }

        @Override
        public boolean isReferenceToPrimaryKey() {
            return this.getWrappedObject().isReferenceToPrimaryKey();
        }

        @Override
        public List<ColumnWrapper> getReferencedColumns() {
            List columns = this.foreignKey.getReferencedColumns();
            if (this.referencedColumns == null) {
                this.initReferencedColumns(columns);
            } else if (columns == null) {
                this.referencedColumns = null;
            } else if (this.referencedColumns.size() != columns.size()) {
                this.initReferencedColumns(columns);
            } else {
                this.syncReferencedColumns(columns);
            }
            return this.referencedColumns;
        }

        @Override
        public boolean containsColumn(ColumnWrapper column) {
            return this.getWrappedObject().containsColumn((Column)column.getWrappedObject());
        }

        private void initReferencedColumns(List<Column> columns) {
            this.referencedColumns = new ArrayList<ColumnWrapper>(columns.size());
            for (int i = 0; i < columns.size(); ++i) {
                this.referencedColumns.add(ColumnWrapperFactory.createColumnWrapper(columns.get(i)));
            }
        }

        private void syncReferencedColumns(List<Column> columns) {
            for (int i = 0; i < columns.size(); ++i) {
                if (this.referencedColumns.get(i).getWrappedObject() == columns.get(i)) continue;
                this.referencedColumns.set(i, ColumnWrapperFactory.createColumnWrapper(columns.get(i)));
            }
        }
    }
}

