/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.internal.export.cfg.CfgExporter;
import org.hibernate.tool.internal.export.common.GenericExporter;
import org.hibernate.tool.internal.export.ddl.DdlExporter;
import org.hibernate.tool.internal.export.query.QueryExporter;
import org.hibernate.tool.orm.jbt.api.wrp.ArtifactCollectorWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ConfigurationWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.DdlExporterWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ExporterWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.GenericExporterWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.QueryExporterWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.DdlExporterWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.GenericExporterWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.QueryExporterWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.util.ConfigurationMetadataDescriptor;
import org.hibernate.tool.orm.jbt.internal.util.DummyMetadataDescriptor;
import org.hibernate.tool.orm.jbt.internal.util.ReflectUtil;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class ExporterWrapperFactory {
    public static ExporterWrapper createExporterWrapper(String className) {
        Exporter wrappedExporter = (Exporter)ReflectUtil.createInstance(className);
        return ExporterWrapperFactory.createExporterWrapper(wrappedExporter);
    }

    private static ExporterWrapper createExporterWrapper(Exporter wrappedExporter) {
        return new ExporterWrapperImpl(wrappedExporter);
    }

    private static class ExporterWrapperImpl
    extends AbstractWrapper
    implements ExporterWrapper {
        private Exporter exporter = null;

        private ExporterWrapperImpl(Exporter exporter) {
            this.exporter = exporter;
            if (CfgExporter.class.isAssignableFrom(exporter.getClass())) {
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", new DummyMetadataDescriptor());
            } else {
                exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", new ConfigurationMetadataDescriptor(new Configuration()));
            }
        }

        public Exporter getWrappedObject() {
            return this.exporter;
        }

        @Override
        public void setConfiguration(ConfigurationWrapper configuration) {
            if (CfgExporter.class.isAssignableFrom(this.exporter.getClass())) {
                ((CfgExporter)this.exporter).setCustomProperties(configuration.getProperties());
            }
            this.exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", new ConfigurationMetadataDescriptor((Configuration)configuration.getWrappedObject()));
        }

        @Override
        public void setArtifactCollector(ArtifactCollectorWrapper artifactCollectorWrapper) {
            this.exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ArtifactCollector", artifactCollectorWrapper.getWrappedObject());
        }

        @Override
        public void setOutputDirectory(File dir) {
            this.exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", dir);
        }

        @Override
        public void setTemplatePath(String[] templatePath) {
            this.exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplatePath", templatePath);
        }

        @Override
        public void start() {
            this.exporter.start();
        }

        @Override
        public Properties getProperties() {
            return this.exporter.getProperties();
        }

        @Override
        public GenericExporterWrapper getGenericExporter() {
            if (this.exporter instanceof GenericExporter) {
                return GenericExporterWrapperFactory.createGenericExporterWrapper((GenericExporter)this.exporter);
            }
            return null;
        }

        @Override
        public DdlExporterWrapper getHbm2DDLExporter() {
            if (this.exporter instanceof DdlExporter) {
                return DdlExporterWrapperFactory.createDdlExporterWrapper((DdlExporter)this.exporter);
            }
            return null;
        }

        @Override
        public QueryExporterWrapper getQueryExporter() {
            if (this.exporter instanceof QueryExporter) {
                return QueryExporterWrapperFactory.createQueryExporterWrapper((QueryExporter)this.exporter);
            }
            return null;
        }

        @Override
        public void setCustomProperties(Properties properties) {
            if (this.exporter instanceof CfgExporter) {
                ((CfgExporter)this.exporter).setCustomProperties(properties);
            }
        }

        @Override
        public void setOutput(StringWriter stringWriter) {
            if (this.exporter instanceof CfgExporter) {
                ((CfgExporter)this.exporter).setOutput((Writer)stringWriter);
            }
        }
    }
}

