/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.tool.orm.jbt.api.wrp.TypeWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.TypeWrapperFactory;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public class TypeRegistry {
    static Map<String, TypeWrapper> TYPE_REGISTRY = new HashMap<String, TypeWrapper>();
    static Map<TypeWrapper, String> TYPE_FORMATS = null;
    private static final BasicTypeRegistry BASIC_TYPE_REGISTRY = new TypeConfiguration().getBasicTypeRegistry();

    public static TypeWrapper getType(String name) {
        if (!TYPE_REGISTRY.containsKey(name)) {
            BasicType basicType = BASIC_TYPE_REGISTRY.getRegisteredType(name);
            if (basicType != null) {
                TYPE_REGISTRY.put(name, TypeWrapperFactory.createTypeWrapper((Type)basicType));
            } else {
                TYPE_REGISTRY.put(name, null);
            }
        }
        return TYPE_REGISTRY.get(name);
    }

    public static Map<TypeWrapper, String> getTypeFormats() {
        if (TYPE_FORMATS == null) {
            TypeRegistry.initializeTypeFormats();
        }
        return TYPE_FORMATS;
    }

    private static void initializeTypeFormats() {
        TYPE_FORMATS = new HashMap<TypeWrapper, String>();
        TypeRegistry.addTypeFormat(TypeRegistry.getType("boolean"), Boolean.TRUE);
        TypeRegistry.addTypeFormat(TypeRegistry.getType("byte"), (byte)42);
        TypeRegistry.addTypeFormat(TypeRegistry.getType("big_integer"), BigInteger.valueOf(42L));
        TypeRegistry.addTypeFormat(TypeRegistry.getType("short"), (short)42);
        TypeRegistry.addTypeFormat(TypeRegistry.getType("calendar"), new GregorianCalendar());
        TypeRegistry.addTypeFormat(TypeRegistry.getType("calendar_date"), new GregorianCalendar());
        TypeRegistry.addTypeFormat(TypeRegistry.getType("integer"), 42);
        TypeRegistry.addTypeFormat(TypeRegistry.getType("big_decimal"), new BigDecimal(42.0));
        TypeRegistry.addTypeFormat(TypeRegistry.getType("character"), Character.valueOf('h'));
        TypeRegistry.addTypeFormat(TypeRegistry.getType("class"), Class.class);
        TypeRegistry.addTypeFormat(TypeRegistry.getType("currency"), Currency.getInstance(Locale.getDefault()));
        TypeRegistry.addTypeFormat(TypeRegistry.getType("date"), new Date());
        TypeRegistry.addTypeFormat(TypeRegistry.getType("double"), 42.42);
        TypeRegistry.addTypeFormat(TypeRegistry.getType("float"), Float.valueOf(42.42f));
        TypeRegistry.addTypeFormat(TypeRegistry.getType("locale"), Locale.getDefault());
        TypeRegistry.addTypeFormat(TypeRegistry.getType("long"), 42L);
        TypeRegistry.addTypeFormat(TypeRegistry.getType("string"), "a string");
        TypeRegistry.addTypeFormat(TypeRegistry.getType("text"), "a text");
        TypeRegistry.addTypeFormat(TypeRegistry.getType("time"), new Date());
        TypeRegistry.addTypeFormat(TypeRegistry.getType("timestamp"), new Date());
        TypeRegistry.addTypeFormat(TypeRegistry.getType("timezone"), TimeZone.getDefault());
        TypeRegistry.addTypeFormat(TypeRegistry.getType("true_false"), Boolean.TRUE);
        TypeRegistry.addTypeFormat(TypeRegistry.getType("yes_no"), Boolean.TRUE);
    }

    private static void addTypeFormat(TypeWrapper type, Object value) {
        TYPE_FORMATS.put(type, type.toString(value));
    }
}

