/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.orm.jbt.internal.util.ExtendedConfiguration;
import org.hibernate.tool.orm.jbt.internal.util.MetadataHelper;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class NativeConfiguration
extends Configuration
implements ExtendedConfiguration {
    private EntityResolver entityResolver = null;
    private ImplicitNamingStrategy namingStrategy = null;
    private Metadata metadata = null;

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setNamingStrategy(ImplicitNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Override
    public ImplicitNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public Configuration configure(Document document) {
        File tempFile = null;
        Configuration result = null;
        this.metadata = null;
        try {
            tempFile = File.createTempFile(document.toString(), "cfg.xml");
            DOMSource domSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult stream = new StreamResult(stringWriter);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, stream);
            FileWriter fileWriter = new FileWriter(tempFile);
            fileWriter.write(stringWriter.toString());
            fileWriter.close();
            result = this.configure(tempFile);
        }
        catch (IOException | TransformerException e) {
            throw new RuntimeException("Problem while configuring", e);
        }
        finally {
            tempFile.delete();
        }
        return result;
    }

    @Override
    public void buildMappings() {
        this.buildMetadata();
    }

    @Override
    public Iterator<PersistentClass> getClassMappings() {
        return this.getMetadata().getEntityBindings().iterator();
    }

    @Override
    public PersistentClass getClassMapping(String name) {
        return this.getMetadata().getEntityBinding(name);
    }

    @Override
    public Iterator<Table> getTableMappings() {
        return this.getMetadata().collectTableMappings().iterator();
    }

    @Override
    public void setPreferBasicCompositeIds(boolean b) {
        throw new RuntimeException("Method 'setPreferBasicCompositeIds' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public void setReverseEngineeringStrategy(RevengStrategy strategy) {
        throw new RuntimeException("Method 'setReverseEngineeringStrategy' should not be called on instances of " + this.getClass().getName());
    }

    @Override
    public void readFromJDBC() {
        throw new RuntimeException("Method 'readFromJDBC' should not be called on instances of " + this.getClass().getName());
    }

    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.buildMetadata();
        }
        return this.metadata;
    }

    private void buildMetadata() {
        MetadataSources metadataSources = MetadataHelper.getMetadataSources(this);
        this.getStandardServiceRegistryBuilder().applySettings(this.getProperties());
        this.metadata = metadataSources.buildMetadata(this.getStandardServiceRegistryBuilder().build());
    }
}

