/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceXmlParser;

public class JpaMappingFileHelper {
    public static List<String> findMappingFiles(String persistenceUnitName) {
        ArrayList<String> result = new ArrayList<String>();
        Collection<PersistenceUnitDescriptor> persistenceUnits = JpaMappingFileHelper.locatePersistenceUnits();
        for (PersistenceUnitDescriptor descriptor : persistenceUnits) {
            if (!descriptor.getName().equals(persistenceUnitName)) continue;
            result.addAll(descriptor.getMappingFileNames());
        }
        return result;
    }

    private static Collection<PersistenceUnitDescriptor> locatePersistenceUnits() {
        Collection<Object> units;
        try {
            PersistenceXmlParser parser = PersistenceXmlParser.create();
            List xmlUrls = parser.getClassLoaderService().locateResources("META-INF/persistence.xml");
            units = xmlUrls.isEmpty() ? List.of() : parser.parse(xmlUrls).values();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to locate persistence units", e);
        }
        return units;
    }
}

