/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.orm.jbt.api.wrp.ColumnWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.PrimaryKeyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TableWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.ColumnWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.TableWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class PrimaryKeyWrapperFactory {
    public static PrimaryKeyWrapper createPrimaryKeyWrapper(PrimaryKey wrappedPrimaryKey) {
        return new PrimaryKeyWrapperImpl(wrappedPrimaryKey);
    }

    private static class PrimaryKeyWrapperImpl
    extends AbstractWrapper
    implements PrimaryKeyWrapper {
        private PrimaryKey primaryKey = null;

        private PrimaryKeyWrapperImpl(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
        }

        public PrimaryKey getWrappedObject() {
            return this.primaryKey;
        }

        @Override
        public void addColumn(ColumnWrapper column) {
            this.primaryKey.addColumn((Column)column.getWrappedObject());
        }

        @Override
        public int getColumnSpan() {
            return this.primaryKey.getColumnSpan();
        }

        @Override
        public List<ColumnWrapper> getColumns() {
            ArrayList<ColumnWrapper> result = new ArrayList<ColumnWrapper>();
            for (Column c : this.primaryKey.getColumns()) {
                result.add(ColumnWrapperFactory.createColumnWrapper(c));
            }
            return result;
        }

        @Override
        public ColumnWrapper getColumn(int i) {
            return ColumnWrapperFactory.createColumnWrapper(this.primaryKey.getColumn(i));
        }

        @Override
        public TableWrapper getTable() {
            Table t = this.primaryKey.getTable();
            return t == null ? null : TableWrapperFactory.createTableWrapper(t);
        }

        @Override
        public boolean containsColumn(ColumnWrapper column) {
            return this.primaryKey.containsColumn((Column)column.getWrappedObject());
        }

        @Override
        public Iterator<ColumnWrapper> columnIterator() {
            return this.getColumns().iterator();
        }

        @Override
        public String getName() {
            return this.primaryKey.getName();
        }
    }
}

