/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.tool.orm.jbt.api.wrp.JoinWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.PersistentClassWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.PropertyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TableWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.ValueWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.Wrapper;
import org.hibernate.tool.orm.jbt.internal.factory.JoinWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.PropertyWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.TableWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.ValueWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.util.DummyMetadataBuildingContext;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class PersistentClassWrapperFactory {
    public static PersistentClassWrapper createRootClassWrapper() {
        return PersistentClassWrapperFactory.createPersistentClassWrapper((PersistentClass)new RootClass(DummyMetadataBuildingContext.INSTANCE));
    }

    public static Object createSingleTableSubClassWrapper(PersistentClassWrapper persistentClassWrapper) {
        PersistentClass pc = (PersistentClass)persistentClassWrapper.getWrappedObject();
        SingleTableSubclass sts = new SingleTableSubclass(pc, DummyMetadataBuildingContext.INSTANCE);
        return PersistentClassWrapperFactory.createPersistentClassWrapper((PersistentClass)sts);
    }

    public static Object createJoinedTableSubClassWrapper(PersistentClassWrapper persistentClassWrapper) {
        PersistentClass pc = (PersistentClass)persistentClassWrapper.getWrappedObject();
        JoinedSubclass js = new JoinedSubclass(pc, DummyMetadataBuildingContext.INSTANCE);
        return PersistentClassWrapperFactory.createPersistentClassWrapper((PersistentClass)js);
    }

    public static PersistentClassWrapper createSpecialRootClassWrapper(PropertyWrapper propertyWrapper) {
        return new SpecialRootClassWrapperImpl(propertyWrapper);
    }

    public static PersistentClassWrapper createPersistentClassWrapper(PersistentClass wrappedPersistentClass) {
        return new PersistentClassWrapperImpl(wrappedPersistentClass);
    }

    private static int getOldCode(OptimisticLockStyle ols) {
        return switch (ols) {
            case OptimisticLockStyle.NONE -> -1;
            case OptimisticLockStyle.VERSION -> 0;
            case OptimisticLockStyle.DIRTY -> 1;
            case OptimisticLockStyle.ALL -> 2;
            default -> throw new AssertionFailure("Unknown OptimisticLockStyle");
        };
    }

    private static MetadataBuildingContext getMetadataBuildingContext(Property property) {
        MetadataBuildingContext result = DummyMetadataBuildingContext.INSTANCE;
        try {
            PersistentClass pc;
            if (property != null && (pc = property.getPersistentClass()) != null) {
                Field field = PersistentClass.class.getDeclaredField("metadataBuildingContext");
                field.setAccessible(true);
                result = (MetadataBuildingContext)field.get(pc);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Problem while trying to retrieve MetadataBuildingContext from field", e);
        }
        return result;
    }

    private static class SpecialRootClassWrapperImpl
    extends PersistentClassWrapperImpl {
        private final PropertyWrapper propertyWrapper;
        private PropertyWrapper parentPropertyWrapper;

        private SpecialRootClassWrapperImpl(PropertyWrapper propertyWrapper) {
            super((PersistentClass)new RootClass(PersistentClassWrapperFactory.getMetadataBuildingContext((Property)propertyWrapper.getWrappedObject())));
            this.propertyWrapper = propertyWrapper;
            this.initialize();
        }

        @Override
        public PropertyWrapper getProperty() {
            return this.propertyWrapper;
        }

        @Override
        public PropertyWrapper getParentProperty() {
            return this.parentPropertyWrapper;
        }

        @Override
        public boolean isInstanceOfSpecialRootClass() {
            return true;
        }

        @Override
        public boolean isRootClass() {
            return false;
        }

        private void initialize() {
            Component component = this.getComponent();
            if (component != null) {
                this.setClassName(component.getComponentClassName());
                this.setEntityName(component.getComponentClassName());
                PersistentClass ownerClass = component.getOwner();
                if (component.getParentProperty() != null) {
                    Property parentProperty = new Property();
                    parentProperty.setName(component.getParentProperty());
                    parentProperty.setPersistentClass(ownerClass);
                    this.parentPropertyWrapper = PropertyWrapperFactory.createPropertyWrapper(parentProperty);
                }
                for (Property property : component.getProperties()) {
                    if (property == null) continue;
                    this.addProperty(PropertyWrapperFactory.createPropertyWrapper(property));
                }
            }
        }

        private Component getComponent() {
            Value v;
            Component result = null;
            if (this.propertyWrapper != null && (v = ((Property)this.propertyWrapper.getWrappedObject()).getValue()) != null) {
                if (v instanceof Wrapper) {
                    v = (Value)((Wrapper)v).getWrappedObject();
                }
                if (Collection.class.isAssignableFrom(v.getClass())) {
                    v = ((Collection)v).getElement();
                }
                if (v != null && Component.class.isAssignableFrom(v.getClass())) {
                    result = (Component)v;
                }
            }
            return result;
        }
    }

    private static class PersistentClassWrapperImpl
    extends AbstractWrapper
    implements PersistentClassWrapper {
        private PersistentClass persistentClass = null;

        private PersistentClassWrapperImpl(PersistentClass persistentClass) {
            this.persistentClass = persistentClass;
        }

        public PersistentClass getWrappedObject() {
            return this.persistentClass;
        }

        @Override
        public boolean isAssignableToRootClass() {
            return this.isInstanceOfRootClass();
        }

        @Override
        public boolean isRootClass() {
            return this.persistentClass.getClass() == RootClass.class;
        }

        @Override
        public boolean isInstanceOfRootClass() {
            return RootClass.class.isAssignableFrom(this.persistentClass.getClass());
        }

        @Override
        public boolean isInstanceOfSubclass() {
            return Subclass.class.isAssignableFrom(this.persistentClass.getClass());
        }

        @Override
        public boolean isInstanceOfJoinedSubclass() {
            return JoinedSubclass.class.isAssignableFrom(this.persistentClass.getClass());
        }

        @Override
        public PropertyWrapper getProperty() {
            throw new RuntimeException("getProperty() is only allowed on SpecialRootClass");
        }

        @Override
        public void setTable(TableWrapper tableWrapper) {
            Table table;
            Table table2 = table = tableWrapper == null ? null : (Table)tableWrapper.getWrappedObject();
            if (this.isInstanceOfRootClass()) {
                ((RootClass)this.persistentClass).setTable(table);
            } else if (this.isInstanceOfJoinedSubclass()) {
                ((JoinedSubclass)this.persistentClass).setTable(table);
            } else {
                throw new RuntimeException("Method 'setTable(Table)' is not supported.");
            }
        }

        @Override
        public void setIdentifier(ValueWrapper value) {
            if (!this.isInstanceOfRootClass()) {
                throw new RuntimeException("Method 'setIdentifier(Value)' can only be called on RootClass instances");
            }
            ((RootClass)this.persistentClass).setIdentifier(value == null ? null : (KeyValue)value.getWrappedObject());
        }

        @Override
        public void setKey(ValueWrapper value) {
            if (!this.isInstanceOfJoinedSubclass()) {
                throw new RuntimeException("setKey(Value) is only allowed on JoinedSubclass");
            }
            ((JoinedSubclass)this.persistentClass).setKey(value == null ? null : (KeyValue)value.getWrappedObject());
        }

        @Override
        public boolean isInstanceOfSpecialRootClass() {
            return false;
        }

        @Override
        public PropertyWrapper getParentProperty() {
            throw new RuntimeException("getParentProperty() is only allowed on SpecialRootClass");
        }

        @Override
        public void setIdentifierProperty(PropertyWrapper p) {
            if (!this.isInstanceOfRootClass()) {
                throw new RuntimeException("setIdentifierProperty(Property) is only allowed on RootClass instances");
            }
            ((RootClass)this.persistentClass).setIdentifierProperty(p == null ? null : (Property)p.getWrappedObject());
        }

        @Override
        public void setDiscriminator(ValueWrapper value) {
            if (!this.isInstanceOfRootClass()) {
                throw new RuntimeException("Method 'setDiscriminator(Value)' can only be called on RootClass instances");
            }
            ((RootClass)this.persistentClass).setDiscriminator(value == null ? null : (Value)value.getWrappedObject());
        }

        @Override
        public boolean isLazyPropertiesCacheable() {
            if (!this.isInstanceOfRootClass()) {
                throw new RuntimeException("Method 'isLazyPropertiesCacheable()' can only be called on RootClass instances");
            }
            return ((RootClass)this.persistentClass).isLazyPropertiesCacheable();
        }

        @Override
        public Iterator<PropertyWrapper> getPropertyIterator() {
            return this.getProperties().iterator();
        }

        @Override
        public Iterator<JoinWrapper> getJoinIterator() {
            return this.getJoins().iterator();
        }

        @Override
        public Iterator<PersistentClassWrapper> getSubclassIterator() {
            return this.getSubclasses().iterator();
        }

        @Override
        public Iterator<PropertyWrapper> getPropertyClosureIterator() {
            return this.getPropertyClosure().iterator();
        }

        @Override
        public String getEntityName() {
            return this.persistentClass.getEntityName();
        }

        @Override
        public String getClassName() {
            return this.persistentClass.getClassName();
        }

        @Override
        public PropertyWrapper getIdentifierProperty() {
            Property p = this.persistentClass.getIdentifierProperty();
            return p == null ? null : PropertyWrapperFactory.createPropertyWrapper(p);
        }

        @Override
        public boolean hasIdentifierProperty() {
            return this.persistentClass.hasIdentifierProperty();
        }

        @Override
        public PersistentClassWrapper getRootClass() {
            RootClass pc = this.persistentClass.getRootClass();
            return pc == null ? null : PersistentClassWrapperFactory.createPersistentClassWrapper((PersistentClass)pc);
        }

        @Override
        public PersistentClassWrapper getSuperclass() {
            PersistentClass pc = this.persistentClass.getSuperclass();
            return pc == null ? null : PersistentClassWrapperFactory.createPersistentClassWrapper(pc);
        }

        @Override
        public PropertyWrapper getProperty(String name) {
            Property p = this.persistentClass.getProperty(name);
            return p == null ? null : PropertyWrapperFactory.createPropertyWrapper(p);
        }

        @Override
        public TableWrapper getTable() {
            Table t = this.persistentClass.getTable();
            return t == null ? null : TableWrapperFactory.createTableWrapper(t);
        }

        @Override
        public Boolean isAbstract() {
            return this.persistentClass.isAbstract();
        }

        @Override
        public ValueWrapper getDiscriminator() {
            Value v = this.persistentClass.getDiscriminator();
            return v == null ? null : ValueWrapperFactory.createValueWrapper(v);
        }

        @Override
        public ValueWrapper getIdentifier() {
            KeyValue v = this.persistentClass.getIdentifier();
            return v == null ? null : ValueWrapperFactory.createValueWrapper((Value)v);
        }

        @Override
        public PropertyWrapper getVersion() {
            Property p = this.persistentClass.getVersion();
            return p == null ? null : PropertyWrapperFactory.createPropertyWrapper(p);
        }

        @Override
        public void setClassName(String name) {
            this.persistentClass.setClassName(name);
        }

        @Override
        public void setEntityName(String name) {
            this.persistentClass.setEntityName(name);
        }

        @Override
        public void setDiscriminatorValue(String str) {
            this.persistentClass.setDiscriminatorValue(str);
        }

        @Override
        public void setAbstract(Boolean b) {
            this.persistentClass.setAbstract(b);
        }

        @Override
        public void addProperty(PropertyWrapper p) {
            this.persistentClass.addProperty((Property)p.getWrappedObject());
        }

        @Override
        public void setProxyInterfaceName(String name) {
            this.persistentClass.setProxyInterfaceName(name);
        }

        @Override
        public void setLazy(boolean b) {
            this.persistentClass.setLazy(b);
        }

        @Override
        public boolean isCustomDeleteCallable() {
            return this.persistentClass.isCustomDeleteCallable();
        }

        @Override
        public boolean isCustomInsertCallable() {
            return this.persistentClass.isCustomInsertCallable();
        }

        @Override
        public boolean isCustomUpdateCallable() {
            return this.persistentClass.isCustomUpdateCallable();
        }

        @Override
        public boolean isDiscriminatorInsertable() {
            return this.persistentClass.isDiscriminatorInsertable();
        }

        @Override
        public boolean isDiscriminatorValueNotNull() {
            return this.persistentClass.isDiscriminatorValueNotNull();
        }

        @Override
        public boolean isDiscriminatorValueNull() {
            return this.persistentClass.isDiscriminatorValueNull();
        }

        @Override
        public boolean isExplicitPolymorphism() {
            return false;
        }

        @Override
        public boolean isForceDiscriminator() {
            return this.persistentClass.isForceDiscriminator();
        }

        @Override
        public boolean isInherited() {
            return this.persistentClass.isInherited();
        }

        @Override
        public boolean isJoinedSubclass() {
            return this.persistentClass.isJoinedSubclass();
        }

        @Override
        public boolean isLazy() {
            return this.persistentClass.isLazy();
        }

        @Override
        public boolean isMutable() {
            return this.persistentClass.isMutable();
        }

        @Override
        public boolean isPolymorphic() {
            return this.persistentClass.isPolymorphic();
        }

        @Override
        public boolean isVersioned() {
            return this.persistentClass.isVersioned();
        }

        @Override
        public int getBatchSize() {
            return this.persistentClass.getBatchSize();
        }

        @Override
        public String getCacheConcurrencyStrategy() {
            return this.persistentClass.getCacheConcurrencyStrategy();
        }

        @Override
        public String getCustomSQLDelete() {
            return this.persistentClass.getCustomSQLDelete();
        }

        @Override
        public String getCustomSQLInsert() {
            return this.persistentClass.getCustomSQLInsert();
        }

        @Override
        public String getCustomSQLUpdate() {
            return this.persistentClass.getCustomSQLUpdate();
        }

        @Override
        public String getDiscriminatorValue() {
            return this.persistentClass.getDiscriminatorValue();
        }

        @Override
        public String getLoaderName() {
            return this.persistentClass.getLoaderName();
        }

        @Override
        public int getOptimisticLockMode() {
            return PersistentClassWrapperFactory.getOldCode(this.persistentClass.getOptimisticLockStyle());
        }

        @Override
        public String getWhere() {
            return this.persistentClass.getWhere();
        }

        @Override
        public TableWrapper getRootTable() {
            Table t = this.persistentClass.getRootTable();
            return t == null ? null : TableWrapperFactory.createTableWrapper(t);
        }

        @Override
        public List<PropertyWrapper> getProperties() {
            ArrayList<PropertyWrapper> result = new ArrayList<PropertyWrapper>();
            for (Property p : this.persistentClass.getProperties()) {
                result.add(PropertyWrapperFactory.createPropertyWrapper(p));
            }
            return result;
        }

        @Override
        public List<JoinWrapper> getJoins() {
            ArrayList<JoinWrapper> result = new ArrayList<JoinWrapper>();
            for (Join j : this.persistentClass.getJoins()) {
                result.add(JoinWrapperFactory.createJoinWrapper(j));
            }
            return result;
        }

        @Override
        public List<PersistentClassWrapper> getSubclasses() {
            ArrayList<PersistentClassWrapper> result = new ArrayList<PersistentClassWrapper>();
            for (Subclass s : this.persistentClass.getSubclasses()) {
                result.add(PersistentClassWrapperFactory.createPersistentClassWrapper((PersistentClass)s));
            }
            return result;
        }

        @Override
        public List<PropertyWrapper> getPropertyClosure() {
            ArrayList<PropertyWrapper> result = new ArrayList<PropertyWrapper>();
            for (Property p : this.persistentClass.getPropertyClosure()) {
                result.add(PropertyWrapperFactory.createPropertyWrapper(p));
            }
            return result;
        }
    }
}

