/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitEntityNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitPrimaryKeyJoinColumnNameSource;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.tool.orm.jbt.api.wrp.NamingStrategyWrapper;
import org.hibernate.tool.orm.jbt.internal.util.ReflectUtil;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class NamingStrategyWrapperFactory {
    public static NamingStrategyWrapper createNamingStrategyWrapper(String className) {
        return NamingStrategyWrapperFactory.createNamingStrategyWrapper((ImplicitNamingStrategy)ReflectUtil.createInstance(className));
    }

    static NamingStrategyWrapper createNamingStrategyWrapper(ImplicitNamingStrategy wrappedNamingStrategy) {
        return new NamingStrategyWrapperImpl(wrappedNamingStrategy);
    }

    private static class NamingStrategyWrapperImpl
    extends AbstractWrapper
    implements NamingStrategyWrapper {
        private ImplicitNamingStrategy namingStrategy = null;

        private NamingStrategyWrapperImpl(ImplicitNamingStrategy namingStrategy) {
            this.namingStrategy = namingStrategy;
        }

        public ImplicitNamingStrategy getWrappedObject() {
            return this.namingStrategy;
        }

        @Override
        public String collectionTableName(final String ownerEntity, final String ownerEntityTable, String associatedEntity, String associatedEntityTable, final String propertyName) {
            ImplicitCollectionTableNameSource ictns = new ImplicitCollectionTableNameSource(){

                public MetadataBuildingContext getBuildingContext() {
                    return null;
                }

                public Identifier getOwningPhysicalTableName() {
                    return Identifier.toIdentifier((String)ownerEntityTable);
                }

                public AttributePath getOwningAttributePath() {
                    return AttributePath.parse((String)propertyName);
                }

                public EntityNaming getOwningEntityNaming() {
                    return new EntityNaming(){

                        public String getJpaEntityName() {
                            return ownerEntity;
                        }

                        public String getEntityName() {
                            return ownerEntity;
                        }

                        public String getClassName() {
                            return ownerEntity;
                        }
                    };
                }
            };
            return this.getWrappedObject().determineCollectionTableName(ictns).getText();
        }

        @Override
        public String columnName(final String name) {
            ImplicitBasicColumnNameSource ibcns = new ImplicitBasicColumnNameSource(){

                public MetadataBuildingContext getBuildingContext() {
                    return null;
                }

                public AttributePath getAttributePath() {
                    return AttributePath.parse((String)name);
                }

                public boolean isCollectionElement() {
                    return false;
                }
            };
            return this.getWrappedObject().determineBasicColumnName(ibcns).getText();
        }

        @Override
        public String propertyToColumnName(String name) {
            return this.columnName(name);
        }

        @Override
        public String tableName(final String name) {
            ImplicitEntityNameSource iens = new ImplicitEntityNameSource(){

                public MetadataBuildingContext getBuildingContext() {
                    return null;
                }

                public EntityNaming getEntityNaming() {
                    return new EntityNaming(){

                        public String getJpaEntityName() {
                            return name;
                        }

                        public String getEntityName() {
                            return name;
                        }

                        public String getClassName() {
                            return name;
                        }
                    };
                }
            };
            return this.getWrappedObject().determinePrimaryTableName(iens).getText();
        }

        @Override
        public String classToTableName(String name) {
            return this.tableName(name);
        }

        @Override
        public String joinKeyColumnName(final String primaryKeyColumnName, final String primaryTableName) {
            ImplicitPrimaryKeyJoinColumnNameSource ipkjcns = new ImplicitPrimaryKeyJoinColumnNameSource(){

                public MetadataBuildingContext getBuildingContext() {
                    return null;
                }

                public Identifier getReferencedTableName() {
                    return Identifier.toIdentifier((String)primaryTableName);
                }

                public Identifier getReferencedPrimaryKeyColumnName() {
                    return Identifier.toIdentifier((String)primaryKeyColumnName);
                }
            };
            return this.getWrappedObject().determinePrimaryKeyJoinColumnName(ipkjcns).getText();
        }

        @Override
        public String getStrategyClassName() {
            return this.getWrappedObject().getClass().getName();
        }
    }
}

