/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tool.orm.jbt.api.wrp.ClassMetadataWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.SessionWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TypeWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.TypeWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;
import org.hibernate.type.Type;

public class ClassMetadataWrapperFactory {
    public static ClassMetadataWrapper createClassMetadataWrapper(EntityPersister entityPersister) {
        return new ClassMetadataWrapperImpl(entityPersister);
    }

    private static class ClassMetadataWrapperImpl
    extends AbstractWrapper
    implements ClassMetadataWrapper {
        private EntityPersister wrappedClassMetadata = null;
        private TypeWrapper[] propertyTypeWrappers = null;
        private TypeWrapper identifierTypeWrapper = null;

        private ClassMetadataWrapperImpl(EntityPersister entityPersister) {
            this.wrappedClassMetadata = entityPersister;
        }

        public EntityPersister getWrappedObject() {
            return this.wrappedClassMetadata;
        }

        @Override
        public String getEntityName() {
            return this.wrappedClassMetadata.getEntityName();
        }

        @Override
        public String getIdentifierPropertyName() {
            return this.wrappedClassMetadata.getIdentifierPropertyName();
        }

        @Override
        public String[] getPropertyNames() {
            return this.wrappedClassMetadata.getPropertyNames();
        }

        @Override
        public TypeWrapper[] getPropertyTypes() {
            if (this.propertyTypeWrappers == null) {
                this.initPropertyTypeWrappers();
            } else {
                this.syncPropertyTypeWrappers();
            }
            return this.propertyTypeWrappers;
        }

        @Override
        public Class<?> getMappedClass() {
            return this.wrappedClassMetadata.getMappedClass();
        }

        @Override
        public TypeWrapper getIdentifierType() {
            Type identifierType = this.wrappedClassMetadata.getIdentifierType();
            if (this.identifierTypeWrapper == null || this.identifierTypeWrapper.getWrappedObject() != identifierType) {
                this.identifierTypeWrapper = TypeWrapperFactory.createTypeWrapper(identifierType);
            }
            return this.identifierTypeWrapper;
        }

        @Override
        public Object getPropertyValue(Object object, String name) {
            return this.wrappedClassMetadata.getPropertyValue(object, name);
        }

        @Override
        public boolean hasIdentifierProperty() {
            return this.wrappedClassMetadata.hasIdentifierProperty();
        }

        @Override
        public Object getIdentifier(Object object, SessionWrapper sessionWrapper) {
            return this.wrappedClassMetadata.getIdentifier(object, (SharedSessionContractImplementor)sessionWrapper.getWrappedObject());
        }

        @Override
        public boolean isInstanceOfAbstractEntityPersister() {
            return this.getWrappedObject() instanceof AbstractEntityPersister;
        }

        @Override
        public Integer getPropertyIndexOrNull(String id) {
            return this.wrappedClassMetadata.getEntityMetamodel().getPropertyIndexOrNull(id);
        }

        @Override
        public Object getTuplizerPropertyValue(Object entity, int i) {
            return this.wrappedClassMetadata.getValue(entity, i);
        }

        private void initPropertyTypeWrappers() {
            Type[] propertyTypes = this.wrappedClassMetadata.getPropertyTypes();
            this.propertyTypeWrappers = new TypeWrapper[propertyTypes.length];
            for (int i = 0; i < propertyTypes.length; ++i) {
                this.propertyTypeWrappers[i] = TypeWrapperFactory.createTypeWrapper(propertyTypes[i]);
            }
        }

        private void syncPropertyTypeWrappers() {
            Type[] propertyTypes = this.wrappedClassMetadata.getPropertyTypes();
            if (this.propertyTypeWrappers.length != propertyTypes.length) {
                this.initPropertyTypeWrappers();
            } else {
                for (int i = 0; i < propertyTypes.length; ++i) {
                    if (this.propertyTypeWrappers[i].getWrappedObject() == propertyTypes[i]) continue;
                    this.propertyTypeWrappers[i] = TypeWrapperFactory.createTypeWrapper(propertyTypes[i]);
                }
            }
        }
    }
}

