/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.util;

import java.lang.reflect.Field;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Value;
import org.hibernate.tool.orm.jbt.api.wrp.Wrapper;
import org.hibernate.tool.orm.jbt.internal.util.DummyMetadataBuildingContext;

public class SpecialRootClass
extends RootClass {
    private Property property;
    private Property parentProperty;

    public SpecialRootClass(Property property) {
        super(SpecialRootClass.getMetadataBuildingContext(property));
        this.property = property;
        this.initialize();
    }

    public Property getProperty() {
        return this.property;
    }

    public Property getParentProperty() {
        return this.parentProperty;
    }

    private void initialize() {
        Component component = this.getComponent();
        if (component != null) {
            this.setClassName(component.getComponentClassName());
            this.setEntityName(component.getComponentClassName());
            PersistentClass ownerClass = component.getOwner();
            if (component.getParentProperty() != null) {
                this.parentProperty = new Property();
                this.parentProperty.setName(component.getParentProperty());
                this.parentProperty.setPersistentClass(ownerClass);
            }
            for (Property property : component.getProperties()) {
                if (property == null) continue;
                this.addProperty(property);
            }
        }
    }

    private Component getComponent() {
        Value v;
        Component result = null;
        if (this.property != null && (v = this.property.getValue()) != null) {
            if (v instanceof Wrapper) {
                v = (Value)((Wrapper)v).getWrappedObject();
            }
            if (Collection.class.isAssignableFrom(v.getClass())) {
                v = ((Collection)v).getElement();
            }
            if (v != null && Component.class.isAssignableFrom(v.getClass())) {
                result = (Component)v;
            }
        }
        return result;
    }

    private static MetadataBuildingContext getMetadataBuildingContext(Property property) {
        MetadataBuildingContext result = DummyMetadataBuildingContext.INSTANCE;
        try {
            PersistentClass pc;
            if (property != null && (pc = property.getPersistentClass()) != null) {
                Field field = PersistentClass.class.getDeclaredField("metadataBuildingContext");
                field.setAccessible(true);
                result = (MetadataBuildingContext)field.get(pc);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Problem while trying to retrieve MetadataBuildingContext from field", e);
        }
        return result;
    }
}

