/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.util;

import java.util.Map;

public class PrimitiveHelper {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_CLASSES_MAP = Map.of(Integer.class, Integer.TYPE, Short.class, Short.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Boolean.class, Boolean.TYPE);

    public static boolean isPrimitiveWrapperClass(Class<?> candidateClass) {
        return PRIMITIVE_CLASSES_MAP.keySet().contains(candidateClass);
    }

    private static boolean isPrimitiveClass(Class<?> candidateClass) {
        return PRIMITIVE_CLASSES_MAP.values().contains(candidateClass);
    }

    public static boolean isPrimitive(Class<?> candidateClass) {
        return PrimitiveHelper.isPrimitiveWrapperClass(candidateClass) || PrimitiveHelper.isPrimitiveClass(candidateClass);
    }

    public static Class<?> getPrimitiveClass(Class<?> candidateClass) {
        return PRIMITIVE_CLASSES_MAP.get(candidateClass);
    }
}

