/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengDialectFactory;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.reader.DatabaseReader;
import org.hibernate.tool.orm.jbt.api.wrp.DatabaseReaderWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.RevengStrategyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TableWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.TableWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;

public class DatabaseReaderWrapperFactory {
    public static DatabaseReaderWrapper createDatabaseReaderWrapper(Properties properties, RevengStrategyWrapper revengStrategy) {
        return new DatabaseReaderWrapperImpl(properties, (RevengStrategy)revengStrategy.getWrappedObject());
    }

    static class DatabaseReaderWrapperImpl
    extends AbstractWrapper
    implements DatabaseReaderWrapper {
        DatabaseReader databaseReader = null;
        RevengMetadataCollector revengMetadataCollector = null;

        public DatabaseReaderWrapperImpl(Properties properties, RevengStrategy revengStrategy) {
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(properties).build();
            MetadataBuilderImpl.MetadataBuildingOptionsImpl metadataBuildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistry);
            BootstrapContextImpl bootstrapContext = new BootstrapContextImpl(serviceRegistry, (MetadataBuildingOptions)metadataBuildingOptions);
            metadataBuildingOptions.setBootstrapContext((BootstrapContext)bootstrapContext);
            InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl((BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions);
            RevengDialect mdd = RevengDialectFactory.createMetaDataDialect((Dialect)((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getDialect(), (Properties)properties);
            this.databaseReader = DatabaseReader.create((Properties)properties, (RevengStrategy)revengStrategy, (RevengDialect)mdd, (ServiceRegistry)serviceRegistry);
            MetadataBuildingContextRootImpl metadataBuildingContext = new MetadataBuildingContextRootImpl("JBoss Tools", (BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions, (InFlightMetadataCollector)metadataCollector);
            this.revengMetadataCollector = new RevengMetadataCollector((MetadataBuildingContext)metadataBuildingContext);
        }

        @Override
        public Map<String, List<TableWrapper>> collectDatabaseTables() {
            this.databaseReader.readDatabaseSchema(this.revengMetadataCollector);
            HashMap<String, List<TableWrapper>> result = new HashMap<String, List<TableWrapper>>();
            for (Table table : this.revengMetadataCollector.getTables()) {
                ArrayList<TableWrapper> list;
                Object qualifier = "";
                if (table.getCatalog() != null) {
                    qualifier = (String)qualifier + table.getCatalog();
                }
                if (table.getSchema() != null) {
                    if (!"".equals(qualifier)) {
                        qualifier = (String)qualifier + ".";
                    }
                    qualifier = (String)qualifier + table.getSchema();
                }
                if ((list = (ArrayList<TableWrapper>)result.get(qualifier)) == null) {
                    list = new ArrayList<TableWrapper>();
                    result.put((String)qualifier, list);
                }
                list.add(TableWrapperFactory.createTableWrapper(table));
            }
            return result;
        }
    }
}

