/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.internal.factory;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.orm.jbt.api.wrp.ConfigurationWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.NamingStrategyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.PersistentClassWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.RevengStrategyWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.SessionFactoryWrapper;
import org.hibernate.tool.orm.jbt.api.wrp.TableWrapper;
import org.hibernate.tool.orm.jbt.internal.factory.NamingStrategyWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.PersistentClassWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.SessionFactoryWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.factory.TableWrapperFactory;
import org.hibernate.tool.orm.jbt.internal.util.ExtendedConfiguration;
import org.hibernate.tool.orm.jbt.internal.util.JpaConfiguration;
import org.hibernate.tool.orm.jbt.internal.util.NativeConfiguration;
import org.hibernate.tool.orm.jbt.internal.util.RevengConfiguration;
import org.hibernate.tool.orm.jbt.internal.wrp.AbstractWrapper;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class ConfigurationWrapperFactory {
    public static ConfigurationWrapper createNativeConfigurationWrapper() {
        return ConfigurationWrapperFactory.createConfigurationWrapper(new NativeConfiguration());
    }

    public static ConfigurationWrapper createRevengConfigurationWrapper() {
        return ConfigurationWrapperFactory.createConfigurationWrapper(new RevengConfiguration());
    }

    public static ConfigurationWrapper createJpaConfigurationWrapper(String persistenceUnit, Map<?, ?> properties) {
        return new ConfigurationWrapperImpl(new JpaConfiguration(persistenceUnit, properties));
    }

    private static ConfigurationWrapper createConfigurationWrapper(Configuration wrappedConfiguration) {
        return new ConfigurationWrapperImpl(wrappedConfiguration);
    }

    private static class ConfigurationWrapperImpl
    extends AbstractWrapper
    implements ConfigurationWrapper {
        private Configuration wrappedConfiguration = null;
        private NamingStrategyWrapper namingStrategyWrapper = null;

        private ConfigurationWrapperImpl(Configuration configuration) {
            this.wrappedConfiguration = configuration;
        }

        public Configuration getWrappedObject() {
            return this.wrappedConfiguration;
        }

        @Override
        public String getProperty(String property) {
            return this.wrappedConfiguration.getProperty(property);
        }

        @Override
        public ConfigurationWrapper addFile(File file) {
            this.wrappedConfiguration.addFile(file);
            return this;
        }

        @Override
        public void setProperty(String name, String value) {
            this.wrappedConfiguration.setProperty(name, value);
        }

        @Override
        public ConfigurationWrapper setProperties(Properties properties) {
            this.wrappedConfiguration.setProperties(properties);
            return this;
        }

        @Override
        public void setEntityResolver(EntityResolver entityResolver) {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                ((ExtendedConfiguration)this.wrappedConfiguration).setEntityResolver(entityResolver);
            }
        }

        @Override
        public void setNamingStrategy(NamingStrategyWrapper namingStrategyWrapper) {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                ((ExtendedConfiguration)this.wrappedConfiguration).setNamingStrategy((NamingStrategy)namingStrategyWrapper.getWrappedObject());
            }
        }

        @Override
        public Properties getProperties() {
            return this.wrappedConfiguration.getProperties();
        }

        @Override
        public void addProperties(Properties properties) {
            this.wrappedConfiguration.addProperties(properties);
        }

        @Override
        public ConfigurationWrapper configure(Document document) {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                ((ExtendedConfiguration)this.wrappedConfiguration).configure(document);
            }
            return this;
        }

        @Override
        public ConfigurationWrapper configure(File file) {
            this.wrappedConfiguration.configure(file);
            return this;
        }

        @Override
        public ConfigurationWrapper configure() {
            this.wrappedConfiguration.configure();
            return this;
        }

        @Override
        public void addClass(Class<?> clazz) {
            this.wrappedConfiguration.addClass(clazz);
        }

        @Override
        public void buildMappings() {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                ((ExtendedConfiguration)this.wrappedConfiguration).buildMappings();
            }
        }

        @Override
        public SessionFactoryWrapper buildSessionFactory() {
            return SessionFactoryWrapperFactory.createSessionFactoryWrapper(this.getWrappedObject().buildSessionFactory());
        }

        @Override
        public Iterator<PersistentClassWrapper> getClassMappings() {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                final Iterator<PersistentClass> classMappings = ((ExtendedConfiguration)this.wrappedConfiguration).getClassMappings();
                return new Iterator<PersistentClassWrapper>(){

                    @Override
                    public boolean hasNext() {
                        return classMappings.hasNext();
                    }

                    @Override
                    public PersistentClassWrapper next() {
                        return PersistentClassWrapperFactory.createPersistentClassWrapper((PersistentClass)classMappings.next());
                    }
                };
            }
            return null;
        }

        @Override
        public void setPreferBasicCompositeIds(boolean b) {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                ((ExtendedConfiguration)this.wrappedConfiguration).setPreferBasicCompositeIds(b);
            }
        }

        @Override
        public void setReverseEngineeringStrategy(RevengStrategyWrapper strategy) {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                ((ExtendedConfiguration)this.wrappedConfiguration).setReverseEngineeringStrategy((RevengStrategy)strategy.getWrappedObject());
            }
        }

        @Override
        public void readFromJDBC() {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                ((ExtendedConfiguration)this.wrappedConfiguration).readFromJDBC();
            }
        }

        @Override
        public PersistentClassWrapper getClassMapping(String string) {
            PersistentClass classMapping;
            if (this.wrappedConfiguration instanceof ExtendedConfiguration && (classMapping = ((ExtendedConfiguration)this.wrappedConfiguration).getClassMapping(string)) != null) {
                return PersistentClassWrapperFactory.createPersistentClassWrapper(classMapping);
            }
            return null;
        }

        @Override
        public NamingStrategyWrapper getNamingStrategy() {
            NamingStrategy namingStrategy = null;
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                namingStrategy = ((ExtendedConfiguration)this.wrappedConfiguration).getNamingStrategy();
            }
            if (this.namingStrategyWrapper == null || this.namingStrategyWrapper.getWrappedObject() != namingStrategy) {
                this.namingStrategyWrapper = namingStrategy == null ? null : NamingStrategyWrapperFactory.createNamingStrategyWrapper(namingStrategy);
            }
            return this.namingStrategyWrapper;
        }

        @Override
        public EntityResolver getEntityResolver() {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                return ((ExtendedConfiguration)this.wrappedConfiguration).getEntityResolver();
            }
            return null;
        }

        @Override
        public Iterator<TableWrapper> getTableMappings() {
            if (this.wrappedConfiguration instanceof ExtendedConfiguration) {
                final Iterator<Table> tableMappings = ((ExtendedConfiguration)this.wrappedConfiguration).getTableMappings();
                return new Iterator<TableWrapper>(){

                    @Override
                    public boolean hasNext() {
                        return tableMappings.hasNext();
                    }

                    @Override
                    public TableWrapper next() {
                        return TableWrapperFactory.createTableWrapper((Table)tableMappings.next());
                    }
                };
            }
            return null;
        }
    }
}

