/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.FetchMode;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.tool.orm.jbt.wrp.DelegatingPersistentClassWrapperImpl;
import org.hibernate.tool.orm.jbt.wrp.PropertyWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.TypeWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;
import org.hibernate.type.Type;

public class ValueWrapperFactory {
    public static ValueWrapper createValueWrapper(Value wrappedValue) {
        return (ValueWrapper)Proxy.newProxyInstance(ValueWrapperFactory.class.getClassLoader(), new Class[]{ValueWrapper.class, KeyValue.class}, (InvocationHandler)new ValueWrapperInvocationHandler(wrappedValue));
    }

    private static Method lookupMethodInValueClass(Value value, Method method) {
        try {
            return value.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Iterator<Property> createWrappedPropertyIterator(final Iterator<?> iterator) {
        if (iterator == null) {
            return null;
        }
        return new Iterator<Property>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Property next() {
                return PropertyWrapperFactory.createPropertyWrapper((Property)iterator.next());
            }
        };
    }

    private static class ValueWrapperInvocationHandler
    implements ValueExtension,
    InvocationHandler {
        private Value extendedValue = null;

        public ValueWrapperInvocationHandler(Value value) {
            this.extendedValue = value;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            try {
                Method valueClassMethod = ValueWrapperFactory.lookupMethodInValueClass(this.extendedValue, method);
                if (valueClassMethod != null) {
                    result = valueClassMethod.invoke((Object)this.extendedValue, args);
                    if (result != null && Value.class.isAssignableFrom(method.getReturnType())) {
                        result = ValueWrapperFactory.createValueWrapper((Value)result);
                    } else if ("getPropertyIterator".equals(valueClassMethod.getName())) {
                        result = ValueWrapperFactory.createWrappedPropertyIterator((Iterator)result);
                    } else if (result != null && "getAssociatedClass".equals(valueClassMethod.getName())) {
                        result = new DelegatingPersistentClassWrapperImpl((PersistentClass)result);
                    } else if (result != null && "getType".equals(method.getName())) {
                        result = TypeWrapperFactory.createTypeWrapper((Type)result);
                    }
                } else {
                    result = method.invoke((Object)this, args);
                    if (!"getWrappedObject".equals(method.getName()) && result != null && method.getReturnType().isAssignableFrom(Value.class)) {
                        result = ValueWrapperFactory.createValueWrapper((Value)result);
                    }
                }
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            return result;
        }

        @Override
        public Value getWrappedObject() {
            return this.extendedValue;
        }

        @Override
        public Value getElement() {
            try {
                return (Value)this.extendedValue.getClass().getMethod("getElement", new Class[0]).invoke((Object)this.extendedValue, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static interface ValueWrapper
    extends KeyValue,
    ValueExtension {
    }

    static interface ValueExtension
    extends Wrapper {
        default public Value getWrappedObject() {
            return (Value)this;
        }

        default public boolean isCollection() {
            return Collection.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isOneToMany() {
            return OneToMany.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isManyToOne() {
            return ManyToOne.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isOneToOne() {
            return OneToOne.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isMap() {
            return Map.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isList() {
            return List.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isToOne() {
            return ToOne.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isDependantValue() {
            return DependantValue.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isAny() {
            return Any.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isSet() {
            return Set.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isPrimitiveArray() {
            return PrimitiveArray.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isArray() {
            return Array.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isIdentifierBag() {
            return IdentifierBag.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isBag() {
            return Bag.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isComponent() {
            return Component.class.isAssignableFrom(this.getWrappedObject().getClass());
        }

        default public boolean isEmbedded() {
            return false;
        }

        default public Value getElement() {
            return null;
        }

        default public void setElement(Value element) {
        }

        default public void setTable(Table table) {
        }

        default public Table getCollectionTable() {
            return null;
        }

        default public void setCollectionTable(Table table) {
        }

        default public Value getCollectionElement() {
            return this.getElement();
        }

        default public void setIndex(Value index) {
        }

        default public Value getIndex() {
            return null;
        }

        default public void setTypeName(String name) {
        }

        default public String getTypeName() {
            return null;
        }

        default public String getComponentClassName() {
            return null;
        }

        default public boolean isTypeSpecified() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'isTypeSpecified()'.");
        }

        default public KeyValue getKey() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getKey()'.");
        }

        default public String getElementClassName() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getElementClassName()'.");
        }

        default public String getReferencedEntityName() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getReferencedEntityName()'.");
        }

        default public String getEntityName() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getEntityName()'.");
        }

        default public String getForeignKeyName() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getForeignKeyName()'.");
        }

        default public String getParentProperty() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getParentProperty()'.");
        }

        default public PersistentClass getOwner() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getOwner()'.");
        }

        default public Iterator<Property> getPropertyIterator() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getPropertyIterator()'.");
        }

        default public void addColumn(Column column) {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'addColumn(Column)'.");
        }

        default public void setTypeParameters(Properties properties) {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'setTypeParameters(Properties)'.");
        }

        default public void setElementClassName(String name) {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'setElementClassName(String)'.");
        }

        default public void setKey(Value value) {
            if (!Collection.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'setKey(KeyValue)'.");
            }
            ((Collection)this.getWrappedObject()).setKey((KeyValue)value);
        }

        default public void setFetchModeJoin() {
            if (!Fetchable.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'setFetchModeJoin()'.");
            }
            ((Fetchable)this.getWrappedObject()).setFetchMode(FetchMode.JOIN);
        }

        default public boolean isInverse() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'isInverse()'.");
        }

        default public PersistentClass getAssociatedClass() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getAssociatedClass()'.");
        }

        default public void setAssociatedClass(PersistentClass pc) {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'setAssociatedClass(PersistentClass)'.");
        }

        default public void setLazy(boolean b) {
            if (!Fetchable.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'setLazy(boolean)'.");
            }
            ((Fetchable)this.getWrappedObject()).setLazy(b);
        }

        default public void setRole(String role) {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'setRole(String)'.");
        }

        default public void setReferencedEntityName(String name) {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'setReferencedEntityName(String)'.");
        }

        default public Iterator<Selectable> getColumnIterator() {
            return this.getWrappedObject().getSelectables().iterator();
        }
    }
}

