/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.hibernate.tool.orm.jbt.wrp.TypeWrapperFactory;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.spi.TypeConfiguration;

public class TypeFactoryWrapper {
    public static final TypeFactoryWrapper INSTANCE = new TypeFactoryWrapper();
    private static Map<String, TypeWrapperFactory.TypeWrapper> TYPE_REGISTRY = null;
    private static final BasicTypeRegistry BASIC_TYPE_REGISTRY = new TypeConfiguration().getBasicTypeRegistry();
    private Map<TypeWrapperFactory.TypeWrapper, String> typeFormats = null;

    private TypeFactoryWrapper() {
    }

    public TypeWrapperFactory.TypeWrapper getBooleanType() {
        return TypeFactoryWrapper.typeRegistry().get("boolean");
    }

    public TypeWrapperFactory.TypeWrapper getByteType() {
        return TypeFactoryWrapper.typeRegistry().get("byte");
    }

    public TypeWrapperFactory.TypeWrapper getBigIntegerType() {
        return TypeFactoryWrapper.typeRegistry().get("big_integer");
    }

    public TypeWrapperFactory.TypeWrapper getShortType() {
        return TypeFactoryWrapper.typeRegistry().get("short");
    }

    public TypeWrapperFactory.TypeWrapper getCalendarType() {
        return TypeFactoryWrapper.typeRegistry().get("calendar");
    }

    public TypeWrapperFactory.TypeWrapper getCalendarDateType() {
        return TypeFactoryWrapper.typeRegistry().get("calendar_date");
    }

    public TypeWrapperFactory.TypeWrapper getIntegerType() {
        return TypeFactoryWrapper.typeRegistry().get("integer");
    }

    public TypeWrapperFactory.TypeWrapper getBigDecimalType() {
        return TypeFactoryWrapper.typeRegistry().get("big_decimal");
    }

    public TypeWrapperFactory.TypeWrapper getCharacterType() {
        return TypeFactoryWrapper.typeRegistry().get("character");
    }

    public TypeWrapperFactory.TypeWrapper getClassType() {
        return TypeFactoryWrapper.typeRegistry().get("class");
    }

    public TypeWrapperFactory.TypeWrapper getCurrencyType() {
        return TypeFactoryWrapper.typeRegistry().get("currency");
    }

    public TypeWrapperFactory.TypeWrapper getDateType() {
        return TypeFactoryWrapper.typeRegistry().get("date");
    }

    public TypeWrapperFactory.TypeWrapper getDoubleType() {
        return TypeFactoryWrapper.typeRegistry().get("double");
    }

    public TypeWrapperFactory.TypeWrapper getFloatType() {
        return TypeFactoryWrapper.typeRegistry().get("float");
    }

    public TypeWrapperFactory.TypeWrapper getLocaleType() {
        return TypeFactoryWrapper.typeRegistry().get("locale");
    }

    public TypeWrapperFactory.TypeWrapper getLongType() {
        return TypeFactoryWrapper.typeRegistry().get("long");
    }

    public TypeWrapperFactory.TypeWrapper getStringType() {
        return TypeFactoryWrapper.typeRegistry().get("string");
    }

    public TypeWrapperFactory.TypeWrapper getTextType() {
        return TypeFactoryWrapper.typeRegistry().get("text");
    }

    public TypeWrapperFactory.TypeWrapper getTimeType() {
        return TypeFactoryWrapper.typeRegistry().get("time");
    }

    public TypeWrapperFactory.TypeWrapper getTimestampType() {
        return TypeFactoryWrapper.typeRegistry().get("timestamp");
    }

    public TypeWrapperFactory.TypeWrapper getTimezoneType() {
        return TypeFactoryWrapper.typeRegistry().get("timezone");
    }

    public TypeWrapperFactory.TypeWrapper getTrueFalseType() {
        return TypeFactoryWrapper.typeRegistry().get("true_false");
    }

    public TypeWrapperFactory.TypeWrapper getYesNoType() {
        return TypeFactoryWrapper.typeRegistry().get("yes_no");
    }

    public TypeWrapperFactory.TypeWrapper getNamedType(String name) {
        if (!TypeFactoryWrapper.typeRegistry().containsKey(name)) {
            BasicType basicType = BASIC_TYPE_REGISTRY.getRegisteredType(name);
            if (basicType != null) {
                TypeFactoryWrapper.typeRegistry().put(name, TypeWrapperFactory.createTypeWrapper((Type)basicType));
            } else {
                TypeFactoryWrapper.typeRegistry().put(name, null);
            }
        }
        return TypeFactoryWrapper.typeRegistry().get(name);
    }

    public TypeWrapperFactory.TypeWrapper getBasicType(String name) {
        return this.getNamedType(name);
    }

    public Map<TypeWrapperFactory.TypeWrapper, String> getTypeFormats() {
        if (this.typeFormats == null) {
            this.initializeTypeFormats();
        }
        return this.typeFormats;
    }

    protected void initializeTypeFormats() {
        this.typeFormats = new HashMap<TypeWrapperFactory.TypeWrapper, String>();
        this.addTypeFormat(this.getBooleanType(), Boolean.TRUE);
        this.addTypeFormat(this.getByteType(), (byte)42);
        this.addTypeFormat(this.getBigIntegerType(), BigInteger.valueOf(42L));
        this.addTypeFormat(this.getShortType(), (short)42);
        this.addTypeFormat(this.getCalendarType(), new GregorianCalendar());
        this.addTypeFormat(this.getCalendarDateType(), new GregorianCalendar());
        this.addTypeFormat(this.getIntegerType(), 42);
        this.addTypeFormat(this.getBigDecimalType(), new BigDecimal(42.0));
        this.addTypeFormat(this.getCharacterType(), Character.valueOf('h'));
        this.addTypeFormat(this.getClassType(), Class.class);
        this.addTypeFormat(this.getCurrencyType(), Currency.getInstance(Locale.getDefault()));
        this.addTypeFormat(this.getDateType(), new Date());
        this.addTypeFormat(this.getDoubleType(), 42.42);
        this.addTypeFormat(this.getFloatType(), Float.valueOf(42.42f));
        this.addTypeFormat(this.getLocaleType(), Locale.getDefault());
        this.addTypeFormat(this.getLongType(), 42L);
        this.addTypeFormat(this.getStringType(), "a string");
        this.addTypeFormat(this.getTextType(), "a text");
        this.addTypeFormat(this.getTimeType(), new Date());
        this.addTypeFormat(this.getTimestampType(), new Date());
        this.addTypeFormat(this.getTimezoneType(), TimeZone.getDefault());
        this.addTypeFormat(this.getTrueFalseType(), Boolean.TRUE);
        this.addTypeFormat(this.getYesNoType(), Boolean.TRUE);
    }

    protected void addTypeFormat(TypeWrapperFactory.TypeWrapper type, Object value) {
        this.typeFormats.put(type, type.toString(value));
    }

    private static Map<String, TypeWrapperFactory.TypeWrapper> typeRegistry() {
        if (TYPE_REGISTRY == null) {
            TypeFactoryWrapper.createTypeRegistry();
        }
        return TYPE_REGISTRY;
    }

    private static void createTypeRegistry() {
        TYPE_REGISTRY = new HashMap<String, TypeWrapperFactory.TypeWrapper>();
        TYPE_REGISTRY.put("boolean", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("boolean")));
        TYPE_REGISTRY.put("byte", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("byte")));
        TYPE_REGISTRY.put("big_integer", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("big_integer")));
        TYPE_REGISTRY.put("short", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("short")));
        TYPE_REGISTRY.put("calendar", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("calendar")));
        TYPE_REGISTRY.put("calendar_date", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("calendar_date")));
        TYPE_REGISTRY.put("integer", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("integer")));
        TYPE_REGISTRY.put("big_decimal", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("big_decimal")));
        TYPE_REGISTRY.put("character", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("character")));
        TYPE_REGISTRY.put("class", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("class")));
        TYPE_REGISTRY.put("currency", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("currency")));
        TYPE_REGISTRY.put("date", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("date")));
        TYPE_REGISTRY.put("double", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("double")));
        TYPE_REGISTRY.put("float", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("float")));
        TYPE_REGISTRY.put("locale", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("locale")));
        TYPE_REGISTRY.put("long", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("long")));
        TYPE_REGISTRY.put("string", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("string")));
        TYPE_REGISTRY.put("text", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("text")));
        TYPE_REGISTRY.put("time", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("time")));
        TYPE_REGISTRY.put("timestamp", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("timestamp")));
        TYPE_REGISTRY.put("timezone", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("timezone")));
        TYPE_REGISTRY.put("true_false", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("true_false")));
        TYPE_REGISTRY.put("yes_no", TypeWrapperFactory.createTypeWrapper((Type)BASIC_TYPE_REGISTRY.getRegisteredType("yes_no")));
    }
}

