/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.tool.orm.jbt.wrp.CriteriaWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.QueryWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;

public class SessionWrapperFactory {
    public static SessionWrapper createSessionWrapper(SessionFactoryImplementor sessionFactory, SessionImplementor session) {
        return (SessionWrapper)Proxy.newProxyInstance(SessionWrapperFactory.class.getClassLoader(), new Class[]{SessionWrapper.class}, (InvocationHandler)new SessionWrapperInvocationHandler(new SessionWrapperImpl(sessionFactory, session)));
    }

    private static class SessionWrapperImpl
    extends SessionDelegatorBaseImpl
    implements SessionWrapper {
        private SessionFactoryImplementor sessionFactory;

        public SessionWrapperImpl(SessionFactoryImplementor sessionFactory, SessionImplementor delegate) {
            super(delegate);
            this.sessionFactory = sessionFactory;
        }

        public SessionFactoryImplementor getSessionFactory() {
            return this.sessionFactory;
        }

        public SessionImplementor getWrappedObject() {
            return this.delegate();
        }

        @Override
        public Query createCriteria(Class<?> persistentClass) {
            HibernateCriteriaBuilder criteriaBuilder = this.delegate().getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(persistentClass);
            Root root = criteriaQuery.from(persistentClass);
            criteriaQuery.select((Selection)root);
            return CriteriaWrapperFactory.createCriteriaWrapper((Query)this.delegate().createQuery(criteriaQuery));
        }

        public QueryWrapperFactory.QueryWrapper<?> createQuery(String queryString) {
            return QueryWrapperFactory.createQueryWrapper(this.delegate().createQuery(queryString, null));
        }

        public boolean contains(Object o) {
            boolean result;
            block2: {
                result = false;
                try {
                    result = this.delegate().contains(o);
                }
                catch (IllegalArgumentException e) {
                    String message = e.getMessage();
                    if (message.startsWith("Class '") && message.endsWith("' is not an entity class")) break block2;
                    throw e;
                }
            }
            return result;
        }
    }

    private static class SessionWrapperInvocationHandler
    implements InvocationHandler {
        private SessionImplementor session = null;

        private SessionWrapperInvocationHandler(SessionImplementor session) {
            this.session = session;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.session, args);
        }
    }

    static interface SessionWrapper
    extends SessionImplementor,
    Wrapper {
        public Query createCriteria(Class<?> var1);
    }
}

