/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.tool.orm.jbt.wrp.TypeWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.ValueWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;
import org.hibernate.type.Type;

public class PropertyWrapperFactory {
    public static Property createPropertyWrapper(Property wrappedProperty) {
        return new DelegatingPropertyWrapperImpl(wrappedProperty);
    }

    static class DelegatingPropertyWrapperImpl
    extends Property
    implements PropertyWrapper {
        private Property delegate = null;

        public DelegatingPropertyWrapperImpl(Property p) {
            this.delegate = p;
        }

        @Override
        public Property getWrappedObject() {
            return this.delegate;
        }

        @Override
        public Type getType() {
            TypeWrapperFactory.TypeWrapper result = null;
            if (this.getWrappedObject().getValue() != null) {
                Type t = this.getWrappedObject().getType();
                result = t == null ? null : TypeWrapperFactory.createTypeWrapper(t);
            }
            return result;
        }

        @Override
        public Value getValue() {
            Value v = this.getWrappedObject().getValue();
            return v == null ? null : ValueWrapperFactory.createValueWrapper(v);
        }

        @Override
        public void setName(String name) {
            this.getWrappedObject().setName(name);
        }

        @Override
        public void setPersistentClass(PersistentClass pc) {
            this.getWrappedObject().setPersistentClass(pc);
        }

        @Override
        public PersistentClass getPersistentClass() {
            return this.getWrappedObject().getPersistentClass();
        }

        @Override
        public boolean isComposite() {
            return this.getWrappedObject().isComposite();
        }

        @Override
        public String getPropertyAccessorName() {
            return this.getWrappedObject().getPropertyAccessorName();
        }

        @Override
        public String getName() {
            return this.getWrappedObject().getName();
        }

        @Override
        public void setValue(Value value) {
            this.getWrappedObject().setValue(value);
        }

        @Override
        public void setPropertyAccessorName(String name) {
            this.getWrappedObject().setPropertyAccessorName(name);
        }

        @Override
        public void setCascade(String c) {
            this.getWrappedObject().setCascade(c);
        }

        @Override
        public boolean isBackRef() {
            return this.getWrappedObject().isBackRef();
        }

        @Override
        public boolean isSelectable() {
            return this.getWrappedObject().isSelectable();
        }

        @Override
        public boolean isUpdateable() {
            return this.getWrappedObject().isUpdateable();
        }

        @Override
        public String getCascade() {
            return this.getWrappedObject().getCascade();
        }

        @Override
        public boolean isLazy() {
            return this.getWrappedObject().isLazy();
        }

        @Override
        public boolean isOptional() {
            return this.getWrappedObject().isOptional();
        }

        @Override
        public boolean isNaturalIdentifier() {
            return this.getWrappedObject().isNaturalIdentifier();
        }

        @Override
        public boolean isOptimisticLocked() {
            return this.getWrappedObject().isOptimisticLocked();
        }

        @Override
        public boolean isInsertable() {
            return this.getWrappedObject().isInsertable();
        }
    }

    static interface PropertyWrapper
    extends Wrapper {
        public Property getWrappedObject();

        public Value getValue();

        public Type getType();

        public void setName(String var1);

        public void setPersistentClass(PersistentClass var1);

        public PersistentClass getPersistentClass();

        public boolean isComposite();

        public String getPropertyAccessorName();

        public String getName();

        public void setValue(Value var1);

        public void setPropertyAccessorName(String var1);

        public void setCascade(String var1);

        public boolean isBackRef();

        public boolean isSelectable();

        public boolean isUpdateable();

        public String getCascade();

        public boolean isLazy();

        public boolean isOptional();

        public boolean isNaturalIdentifier();

        public boolean isOptimisticLocked();

        public boolean isInsertable();
    }
}

