/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;

public class PrimaryKeyWrapperFactory {
    public static PrimaryKeyWrapper createForeinKeyWrapper(PrimaryKey primaryKey) {
        return (PrimaryKeyWrapper)Proxy.newProxyInstance(PrimaryKeyWrapper.class.getClassLoader(), new Class[]{PrimaryKeyWrapper.class}, (InvocationHandler)new PrimaryKeyWrapperInvocationHandler(primaryKey));
    }

    private static class PrimaryKeyWrapperInvocationHandler
    implements PrimaryKeyWrapper,
    InvocationHandler {
        private PrimaryKey wrappedPrimaryKey = null;

        private PrimaryKeyWrapperInvocationHandler(PrimaryKey primaryKey) {
            this.wrappedPrimaryKey = primaryKey;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        @Override
        public PrimaryKey getWrappedObject() {
            return this.wrappedPrimaryKey;
        }
    }

    static interface PrimaryKeyWrapper
    extends Wrapper {
        public PrimaryKey getWrappedObject();

        default public void addColumn(Column column) {
            this.getWrappedObject().addColumn(column);
        }

        default public int getColumnSpan() {
            return this.getWrappedObject().getColumnSpan();
        }

        default public List<Column> getColumns() {
            return this.getWrappedObject().getColumns();
        }

        default public Column getColumn(int i) {
            return this.getWrappedObject().getColumn(i);
        }

        default public Table getTable() {
            return this.getWrappedObject().getTable();
        }

        default public boolean containsColumn(Column column) {
            return this.getWrappedObject().containsColumn(column);
        }

        default public Iterator<Column> columnIterator() {
            return this.getWrappedObject().getColumns().iterator();
        }

        default public String getName() {
            return this.getWrappedObject().getName();
        }
    }
}

