/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.Method;
import org.hibernate.boot.Metadata;
import org.hibernate.tool.ide.completion.HQLCodeAssist;
import org.hibernate.tool.ide.completion.HQLCompletionProposal;
import org.hibernate.tool.ide.completion.IHQLCompletionRequestor;

public class HqlCodeAssistWrapper
extends HQLCodeAssist {
    public HqlCodeAssistWrapper(Metadata metadata) {
        super(metadata);
    }

    public void codeComplete(String query, int position, Object handler) {
        super.codeComplete(query, position, (IHQLCompletionRequestor)new HqlCompletionRequestorAdapter(handler));
    }

    private static class HqlCompletionRequestorAdapter
    implements IHQLCompletionRequestor {
        private Object handler = null;
        private Method acceptMethod = null;
        private Method completionFailureMethod = null;

        private HqlCompletionRequestorAdapter(Object handler) {
            this.handler = handler;
            this.acceptMethod = this.lookupMethod("accept", Object.class);
            this.completionFailureMethod = this.lookupMethod("completionFailure", String.class);
        }

        public boolean accept(HQLCompletionProposal proposal) {
            try {
                return (Boolean)this.acceptMethod.invoke(this.handler, proposal);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public void completionFailure(String errorMessage) {
            try {
                this.completionFailureMethod.invoke(this.handler, errorMessage);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        private Method lookupMethod(String name, Class<?> argumentClass) {
            Method result = null;
            try {
                result = this.handler.getClass().getMethod(name, argumentClass);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return result;
        }
    }
}

