/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.api.export.ArtifactCollector;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.internal.export.cfg.CfgExporter;
import org.hibernate.tool.internal.export.common.GenericExporter;
import org.hibernate.tool.internal.export.ddl.DdlExporter;
import org.hibernate.tool.internal.export.query.QueryExporter;
import org.hibernate.tool.orm.jbt.util.ConfigurationMetadataDescriptor;
import org.hibernate.tool.orm.jbt.util.DummyMetadataDescriptor;
import org.hibernate.tool.orm.jbt.util.ReflectUtil;
import org.hibernate.tool.orm.jbt.wrp.DdlExporterWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.GenericExporterWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.QueryExporterWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;

public class ExporterWrapperFactory {
    public static ExporterWrapper create(String className) {
        ExporterWrapper result = (ExporterWrapper)Proxy.newProxyInstance(ExporterWrapperFactory.class.getClassLoader(), new Class[]{ExporterWrapper.class}, (InvocationHandler)new ExporterInvocationHandler(className));
        Exporter wrappedExporter = result.getWrappedObject();
        if (CfgExporter.class.isAssignableFrom(wrappedExporter.getClass())) {
            wrappedExporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", new DummyMetadataDescriptor());
        } else {
            wrappedExporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", new ConfigurationMetadataDescriptor(new Configuration()));
        }
        return result;
    }

    static class ExporterWrapperImpl
    implements ExporterWrapper {
        private Exporter delegateExporter = null;

        private ExporterWrapperImpl(String className) {
            this.delegateExporter = (Exporter)ReflectUtil.createInstance(className);
        }

        @Override
        public Exporter getWrappedObject() {
            return this.delegateExporter;
        }
    }

    static interface ExporterWrapper
    extends Wrapper {
        public Exporter getWrappedObject();

        default public void setConfiguration(Configuration configuration) {
            if (CfgExporter.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                ((CfgExporter)this.getWrappedObject()).setCustomProperties(configuration.getProperties());
            }
            this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", new ConfigurationMetadataDescriptor(configuration));
        }

        default public void setArtifactCollector(ArtifactCollector artifactCollector) {
            this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ArtifactCollector", artifactCollector);
        }

        default public void setOutputDirectory(File dir) {
            this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", dir);
        }

        default public void setTemplatePath(String[] templatePath) {
            this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplatePath", templatePath);
        }

        default public void start() {
            this.getWrappedObject().start();
        }

        default public Properties getProperties() {
            return this.getWrappedObject().getProperties();
        }

        default public GenericExporterWrapperFactory.GenericExporterWrapper getGenericExporter() {
            if (this.getWrappedObject() instanceof GenericExporter) {
                return GenericExporterWrapperFactory.create((GenericExporter)this.getWrappedObject());
            }
            return null;
        }

        default public DdlExporterWrapperFactory.DdlExporterWrapper getHbm2DDLExporter() {
            if (this.getWrappedObject() instanceof DdlExporter) {
                return DdlExporterWrapperFactory.create((DdlExporter)this.getWrappedObject());
            }
            return null;
        }

        default public QueryExporterWrapperFactory.QueryExporterWrapper getQueryExporter() {
            if (this.getWrappedObject() instanceof QueryExporter) {
                return QueryExporterWrapperFactory.create((QueryExporter)this.getWrappedObject());
            }
            return null;
        }

        default public void setCustomProperties(Properties properties) {
            if (this.getWrappedObject() instanceof CfgExporter) {
                ((CfgExporter)this.getWrappedObject()).setCustomProperties(properties);
            }
        }

        default public void setOutput(StringWriter stringWriter) {
            if (this.getWrappedObject() instanceof CfgExporter) {
                ((CfgExporter)this.getWrappedObject()).setOutput((Writer)stringWriter);
            }
        }
    }

    private static class ExporterInvocationHandler
    implements InvocationHandler {
        private ExporterWrapper exporterWrapper = null;

        private ExporterInvocationHandler(String className) {
            this.exporterWrapper = new ExporterWrapperImpl(className);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.exporterWrapper, args);
        }
    }
}

