/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.util.HashMap;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Value;
import org.hibernate.tool.orm.jbt.util.MetadataHelper;
import org.hibernate.tool.orm.jbt.wrp.ColumnWrapper;
import org.hibernate.tool.orm.jbt.wrp.ValueWrapperFactory;
import org.hibernate.type.spi.TypeConfiguration;

public class DelegatingColumnWrapperImpl
extends Column
implements ColumnWrapper {
    private static final int DEFAULT_LENGTH = 255;
    private static final int DEFAULT_PRECISION = 19;
    private static final int DEFAULT_SCALE = 2;
    private Column delegate = null;

    public DelegatingColumnWrapperImpl(Column c) {
        super(c.getName());
        this.delegate = c;
    }

    @Override
    public Column getWrappedObject() {
        return this.delegate;
    }

    @Override
    public String getSqlType(Configuration configuration) {
        Metadata metadata = MetadataHelper.getMetadata(configuration);
        TypeConfiguration tc = ((MetadataImpl)metadata).getTypeConfiguration();
        return this.delegate.getSqlType(tc, this.buildDialect(configuration), (Mapping)metadata);
    }

    @Override
    public Long getLength() {
        Long length = this.delegate.getLength();
        return length == null ? Integer.MIN_VALUE : length;
    }

    @Override
    public int getDefaultLength() {
        return 255;
    }

    @Override
    public Integer getPrecision() {
        Integer precision = this.delegate.getPrecision();
        return precision == null ? Integer.MIN_VALUE : precision;
    }

    @Override
    public int getDefaultPrecision() {
        return 19;
    }

    @Override
    public Integer getScale() {
        Integer scale = this.delegate.getScale();
        return scale == null ? Integer.MIN_VALUE : scale;
    }

    @Override
    public int getDefaultScale() {
        return 2;
    }

    @Override
    public Value getValue() {
        Object val = this.delegate.getValue();
        if (val != null) {
            val = ValueWrapperFactory.createValueWrapper(val);
        }
        return val;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public Integer getSqlTypeCode() {
        return this.delegate.getSqlTypeCode();
    }

    @Override
    public String getSqlType() {
        return this.delegate.getSqlType();
    }

    @Override
    public boolean isNullable() {
        return this.delegate.isNullable();
    }

    @Override
    public boolean isUnique() {
        return this.delegate.isUnique();
    }

    @Override
    public void setSqlType(String sqlType) {
        this.delegate.setSqlType(sqlType);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DelegatingColumnWrapperImpl)) {
            return false;
        }
        return ((DelegatingColumnWrapperImpl)o).getWrappedObject().equals(this.delegate);
    }

    private Dialect buildDialect(Configuration configuration) {
        HashMap<String, String> dialectPropertyMap = new HashMap<String, String>();
        dialectPropertyMap.put("hibernate.dialect", configuration.getProperty("hibernate.dialect"));
        DialectFactory df = (DialectFactory)configuration.getStandardServiceRegistryBuilder().build().getService(DialectFactory.class);
        return df.buildDialect(dialectPropertyMap, null);
    }
}

