/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.orm.jbt.util.JpaConfiguration;
import org.hibernate.tool.orm.jbt.util.NativeConfiguration;
import org.hibernate.tool.orm.jbt.util.RevengConfiguration;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class ConfigurationWrapperFactory {
    public static ConfigurationWrapper createNativeConfigurationWrapper() {
        return (ConfigurationWrapper)Proxy.newProxyInstance(ConfigurationWrapperFactory.class.getClassLoader(), new Class[]{ConfigurationWrapper.class}, (InvocationHandler)new ConfigurationWrapperInvocationHandler(new NativeConfigurationWrapperImpl()));
    }

    public static ConfigurationWrapper createRevengConfigurationWrapper() {
        return (ConfigurationWrapper)Proxy.newProxyInstance(ConfigurationWrapperFactory.class.getClassLoader(), new Class[]{ConfigurationWrapper.class}, (InvocationHandler)new ConfigurationWrapperInvocationHandler(new RevengConfigurationWrapperImpl()));
    }

    public static ConfigurationWrapper createJpaConfigurationWrapper(String persistenceUnit, Map<?, ?> properties) {
        return (ConfigurationWrapper)Proxy.newProxyInstance(ConfigurationWrapperFactory.class.getClassLoader(), new Class[]{ConfigurationWrapper.class}, (InvocationHandler)new ConfigurationWrapperInvocationHandler(new JpaConfigurationWrapperImpl(persistenceUnit, properties)));
    }

    static class JpaConfigurationWrapperImpl
    extends JpaConfiguration
    implements ConfigurationWrapper {
        public JpaConfigurationWrapperImpl(String persistenceUnit, Map<?, ?> properties) {
            super(persistenceUnit, properties);
        }
    }

    static class RevengConfigurationWrapperImpl
    extends RevengConfiguration
    implements ConfigurationWrapper {
        RevengConfigurationWrapperImpl() {
        }
    }

    static class NativeConfigurationWrapperImpl
    extends NativeConfiguration
    implements ConfigurationWrapper {
        NativeConfigurationWrapperImpl() {
        }
    }

    static class ConfigurationWrapperInvocationHandler
    implements InvocationHandler {
        private ConfigurationWrapper configurationWrapper = null;

        public ConfigurationWrapperInvocationHandler(ConfigurationWrapper wrapper) {
            this.configurationWrapper = wrapper;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.configurationWrapper, args);
            }
            catch (InvocationTargetException t) {
                throw t.getTargetException();
            }
        }
    }

    static interface ConfigurationWrapper
    extends Wrapper {
        default public Configuration getWrappedObject() {
            return (Configuration)this;
        }

        public String getProperty(String var1);

        public Configuration addFile(File var1);

        public Configuration setProperty(String var1, String var2);

        public Configuration setProperties(Properties var1);

        public void setEntityResolver(EntityResolver var1);

        public void setNamingStrategy(NamingStrategy var1);

        public Properties getProperties();

        public Configuration addProperties(Properties var1);

        public Configuration configure(Document var1);

        public Configuration configure(File var1);

        public Configuration configure();

        public Configuration addClass(Class<?> var1);

        public void buildMappings();

        public SessionFactory buildSessionFactory();

        public Iterator<PersistentClass> getClassMappings();

        public void setPreferBasicCompositeIds(boolean var1);

        public void setReverseEngineeringStrategy(RevengStrategy var1);

        public void readFromJDBC();

        public PersistentClass getClassMapping(String var1);

        public NamingStrategy getNamingStrategy();

        public EntityResolver getEntityResolver();

        public Iterator<Table> getTableMappings();
    }
}

