/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.tool.orm.jbt.wrp.TypeWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;

public class CollectionPersisterWrapperFactory {
    public static Object create(CollectionPersister delegate) {
        return Proxy.newProxyInstance(CollectionPersisterWrapperFactory.class.getClassLoader(), new Class[]{CollectionPersisterWrapper.class}, (InvocationHandler)new CollectionPersisterInvocationHandler(delegate));
    }

    static class CollectionPersisterInvocationHandler
    implements InvocationHandler {
        private CollectionPersister delegate;

        private CollectionPersisterInvocationHandler(CollectionPersister delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getWrappedObject".equals(method.getName())) {
                return this.delegate;
            }
            if ("getElementType".equals(method.getName())) {
                return TypeWrapperFactory.createTypeWrapper(this.delegate.getElementType());
            }
            return method.invoke((Object)this.delegate, args);
        }
    }

    static interface CollectionPersisterWrapper
    extends CollectionPersister,
    Wrapper {
    }
}

