/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.CalendarJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class TypeWrapperFactory {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_CLASSES_MAP = Map.of(Integer.class, Integer.TYPE, Short.class, Short.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Boolean.class, Boolean.TYPE);

    public static TypeWrapper createTypeWrapper(Type wrappedType) {
        return (TypeWrapper)Proxy.newProxyInstance(TypeWrapperFactory.class.getClassLoader(), new Class[]{TypeWrapper.class}, (InvocationHandler)new TypeWrapperInvocationHandler(wrappedType));
    }

    private static Method lookupMethodInTypeClass(Type type, Method method) {
        try {
            return type.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static boolean isPrimitiveWrapperClass(Class<?> candidateClass) {
        return PRIMITIVE_CLASSES_MAP.keySet().contains(candidateClass);
    }

    private static boolean isPrimitiveClass(Class<?> candidateClass) {
        return PRIMITIVE_CLASSES_MAP.values().contains(candidateClass);
    }

    private static boolean isPrimitive(Class<?> candidateClass) {
        return TypeWrapperFactory.isPrimitiveWrapperClass(candidateClass) || TypeWrapperFactory.isPrimitiveClass(candidateClass);
    }

    private static class TypeWrapperInvocationHandler
    implements TypeExtension,
    InvocationHandler {
        private Type extendedType = null;

        public TypeWrapperInvocationHandler(Type type) {
            this.extendedType = type;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Method typeClassMethod = TypeWrapperFactory.lookupMethodInTypeClass(this.extendedType, method);
                if (typeClassMethod != null) {
                    return typeClassMethod.invoke((Object)this.extendedType, args);
                }
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        public Type getWrappedObject() {
            return this.extendedType;
        }
    }

    static interface TypeWrapper
    extends Type,
    TypeExtension {
    }

    static interface TypeExtension
    extends Wrapper {
        default public String toString(Object object) {
            if (BasicType.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                JavaType javaType = ((BasicType)this.getWrappedObject()).getJavaTypeDescriptor();
                if (javaType instanceof CalendarJavaType && object instanceof Calendar) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    return simpleDateFormat.format(((Calendar)object).getTime());
                }
                return javaType.toString(object);
            }
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'toString(Object)'.");
        }

        default public Object fromStringValue(String stringValue) {
            if (BasicType.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                return ((BasicType)this.getWrappedObject()).getJavaTypeDescriptor().fromString((CharSequence)stringValue);
            }
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'fromStringValue(Object)'.");
        }

        default public boolean isOneToOne() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'isOneToOne()'.");
        }

        default public String getReturnedClassName() {
            Class returnedClass = ((Type)this.getWrappedObject()).getReturnedClass();
            return returnedClass == null ? null : returnedClass.getName();
        }

        default public String getAssociatedEntityName() {
            return null;
        }

        default public boolean isIntegerType() {
            return Integer.class.isAssignableFrom(((Type)this.getWrappedObject()).getReturnedClass());
        }

        default public boolean isArrayType() {
            if (CollectionType.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                return ((CollectionType)this.getWrappedObject()).isArrayType();
            }
            return false;
        }

        default public boolean isInstanceOfPrimitiveType() {
            if (!BasicType.class.isAssignableFrom(this.getWrappedObject().getClass())) {
                return false;
            }
            return TypeWrapperFactory.isPrimitive(((BasicType)this.getWrappedObject()).getJavaType());
        }

        default public Class<?> getPrimitiveClass() {
            if (!this.isInstanceOfPrimitiveType()) {
                throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getPrimitiveClass()'.");
            }
            Class javaType = ((BasicType)this.getWrappedObject()).getJavaType();
            if (TypeWrapperFactory.isPrimitiveWrapperClass(javaType)) {
                return PRIMITIVE_CLASSES_MAP.get(javaType);
            }
            return javaType;
        }

        default public String getRole() {
            throw new UnsupportedOperationException("Class '" + this.getWrappedObject().getClass().getName() + "' does not support 'getRole()'.");
        }
    }
}

