/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;
import org.hibernate.type.Type;

public class QueryWrapperFactory {
    public static QueryWrapper<?> createQueryWrapper(Query<?> query) {
        return (QueryWrapper)Proxy.newProxyInstance(QueryWrapperFactory.class.getClassLoader(), new Class[]{QueryWrapper.class}, new QueryWrapperInvocationHandler(query));
    }

    private static boolean isQueryExtensionMethod(Method m) {
        boolean result = true;
        try {
            QueryExtension.class.getMethod(m.getName(), m.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            result = false;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static class QueryWrapperInvocationHandler<T>
    implements InvocationHandler,
    QueryExtension<T> {
        private Query<T> query = null;

        private QueryWrapperInvocationHandler(Query<T> q) {
            this.query = q;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (QueryWrapperFactory.isQueryExtensionMethod(method)) {
                return method.invoke((Object)this, args);
            }
            return method.invoke(this.query, args);
        }

        @Override
        public void setParameterList(String name, List<Object> list, Object anything) {
            this.query.setParameterList(name, list);
        }

        @Override
        public void setParameter(String name, Object value, Object anything) {
            this.query.setParameter(name, value);
        }

        @Override
        public void setParameter(int position, Object value, Object anything) {
            this.query.setParameter(position, value);
        }

        @Override
        public Query<T> getWrappedObject() {
            return this.query;
        }
    }

    static interface QueryWrapper<T>
    extends QueryExtension<T>,
    QueryImplementor<T> {
    }

    static interface QueryExtension<T>
    extends Wrapper {
        public Query<T> getWrappedObject();

        public void setParameterList(String var1, List<Object> var2, Object var3);

        public void setParameter(String var1, Object var2, Object var3);

        public void setParameter(int var1, Object var2, Object var3);

        default public String[] getReturnAliases() {
            return new String[0];
        }

        default public Type[] getReturnTypes() {
            return new Type[0];
        }
    }
}

