/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.hibernate.tool.internal.export.query.QueryExporter;
import org.hibernate.tool.orm.jbt.wrp.GenericExporterWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;

public class QueryExporterWrapperFactory {
    public static QueryExporterWrapper create(QueryExporter wrappedExporter) {
        return (QueryExporterWrapper)Proxy.newProxyInstance(GenericExporterWrapperFactory.class.getClassLoader(), new Class[]{QueryExporterWrapper.class}, (InvocationHandler)new QueryExporterInvocationHandler(wrappedExporter));
    }

    static class QueryExporterWrapperImpl
    implements QueryExporterWrapper {
        private QueryExporter delegateQueryExporter = null;

        private QueryExporterWrapperImpl(QueryExporter wrappedExporter) {
            this.delegateQueryExporter = wrappedExporter;
        }

        @Override
        public QueryExporter getWrappedObject() {
            return this.delegateQueryExporter;
        }
    }

    static interface QueryExporterWrapper
    extends Wrapper {
        public QueryExporter getWrappedObject();

        default public void setQueries(List<String> queries) {
            this.getWrappedObject().setQueries(queries);
        }

        default public void setFilename(String fileName) {
            this.getWrappedObject().getProperties().put("org.hibernate.tool.api.export.ExporterConstants.OutputFileName", fileName);
        }
    }

    private static class QueryExporterInvocationHandler
    implements InvocationHandler {
        private QueryExporterWrapper exporterWrapper = null;

        private QueryExporterInvocationHandler(QueryExporter wrappedExporter) {
            this.exporterWrapper = new QueryExporterWrapperImpl(wrappedExporter);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.exporterWrapper, args);
        }
    }
}

