/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.internal.export.hbm.HbmExporter;
import org.hibernate.tool.internal.export.java.POJOClass;
import org.hibernate.tool.orm.jbt.util.ConfigurationMetadataDescriptor;

public class HbmExporterWrapper
extends HbmExporter {
    private Object delegateExporter;

    public HbmExporterWrapper(Configuration cfg, File file) {
        this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.MetadataDescriptor", new ConfigurationMetadataDescriptor(cfg));
        if (file != null) {
            this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.OutputFileName", file);
        }
    }

    public void setDelegate(Object delegate) {
        this.delegateExporter = delegate;
    }

    public void superExportPOJO(Map<String, Object> map, POJOClass pojoClass) {
        super.exportPOJO(map, pojoClass);
    }

    public File getOutputDirectory() {
        return super.getOutputDirectory();
    }

    public void setOutputDirectory(File file) {
        this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.DestinationFolder", file);
    }

    public void setExportPOJODelegate(Object delegate) {
        this.setDelegate(delegate);
    }

    public void exportPOJO(Map map, POJOClass pojoClass) {
        if (this.delegateExporter == null) {
            super.exportPOJO(map, pojoClass);
        } else {
            this.delegateExporterExportPOJO(map, pojoClass, pojoClass.getQualifiedDeclarationName());
        }
    }

    private void delegateExporterExportPOJO(Map<Object, Object> map, POJOClass pojoClass, String qualifiedDeclarationName) {
        try {
            Method method = this.delegateExporter.getClass().getDeclaredMethod("exportPojo", Map.class, Object.class, String.class);
            method.setAccessible(true);
            method.invoke(this.delegateExporter, map, pojoClass, qualifiedDeclarationName);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

