/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;

public class ForeignKeyWrapperFactory {
    public static ForeignKeyWrapper createForeinKeyWrapper(ForeignKey foreignKey) {
        return (ForeignKeyWrapper)Proxy.newProxyInstance(ForeignKeyWrapper.class.getClassLoader(), new Class[]{ForeignKeyWrapper.class}, (InvocationHandler)new ForeignKeyWrapperInvocationHandler(foreignKey));
    }

    private static Method lookupMethodInForeignKeyClass(ForeignKey foreignKey, Method method) {
        try {
            return foreignKey.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static class ForeignKeyWrapperInvocationHandler
    implements ForeignKeyExtension,
    InvocationHandler {
        private ForeignKey extendedForeignKey = null;

        private ForeignKeyWrapperInvocationHandler(ForeignKey foreignKey) {
            this.extendedForeignKey = foreignKey;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Method foreignKeyClassMethod = ForeignKeyWrapperFactory.lookupMethodInForeignKeyClass(this.extendedForeignKey, method);
                if (foreignKeyClassMethod != null) {
                    return foreignKeyClassMethod.invoke((Object)this.extendedForeignKey, args);
                }
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        public ForeignKey getWrappedObject() {
            return this.extendedForeignKey;
        }
    }

    static interface ForeignKeyWrapper
    extends ForeignKeyExtension {
    }

    static interface ForeignKeyExtension
    extends Wrapper {
        default public Iterator<Column> columnIterator() {
            return ((ForeignKey)this.getWrappedObject()).getColumns().iterator();
        }

        default public Table getReferencedTable() {
            return ((ForeignKey)this.getWrappedObject()).getReferencedTable();
        }

        default public boolean isReferenceToPrimaryKey() {
            return ((ForeignKey)this.getWrappedObject()).isReferenceToPrimaryKey();
        }

        default public List<Column> getReferencedColumns() {
            return ((ForeignKey)this.getWrappedObject()).getReferencedColumns();
        }

        default public boolean containsColumn(Column column) {
            return ((ForeignKey)this.getWrappedObject()).containsColumn(column);
        }
    }
}

