/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tool.orm.jbt.wrp.TypeWrapperFactory;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;
import org.hibernate.type.Type;

public class EntityPersisterWrapperFactory {
    public static Object create(EntityPersister delegate) {
        return Proxy.newProxyInstance(EntityPersisterWrapperFactory.class.getClassLoader(), new Class[]{EntityPersisterWrapper.class}, (InvocationHandler)new EntityPersisterInvocationHandler(delegate));
    }

    private static boolean isEntityPersisterExtensionMethod(Method m) {
        boolean result = true;
        try {
            EntityPersisterExtension.class.getMethod(m.getName(), m.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            result = false;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    static class EntityPersisterInvocationHandler
    implements InvocationHandler,
    EntityPersisterExtension {
        private EntityPersister delegate;

        private EntityPersisterInvocationHandler(EntityPersister delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (EntityPersisterWrapperFactory.isEntityPersisterExtensionMethod(method)) {
                return method.invoke((Object)this, args);
            }
            if ("getPropertyTypes".equals(method.getName())) {
                return this.getPropertyTypes();
            }
            if ("getIdentifierType".equals(method.getName())) {
                return TypeWrapperFactory.createTypeWrapper(this.delegate.getIdentifierType());
            }
            return method.invoke((Object)this.delegate, args);
        }

        @Override
        public EntityPersister getWrappedObject() {
            return this.delegate;
        }

        private TypeWrapperFactory.TypeWrapper[] getPropertyTypes() {
            Type[] types = this.getWrappedObject().getPropertyTypes();
            if (types != null) {
                TypeWrapperFactory.TypeWrapper[] result = new TypeWrapperFactory.TypeWrapper[types.length];
                for (int i = 0; i < types.length; ++i) {
                    result[i] = TypeWrapperFactory.createTypeWrapper(types[i]);
                }
                return result;
            }
            return null;
        }
    }

    static interface EntityPersisterWrapper
    extends EntityPersister,
    EntityPersisterExtension {
    }

    static interface EntityPersisterExtension
    extends Wrapper {
        public EntityPersister getWrappedObject();

        default public boolean isInstanceOfAbstractEntityPersister() {
            return true;
        }

        default public Object getTuplizerPropertyValue(Object entity, int i) {
            return this.getWrappedObject().getValue(entity, i);
        }

        default public Integer getPropertyIndexOrNull(String propertyName) {
            return this.getWrappedObject().getEntityMetamodel().getPropertyIndexOrNull(propertyName);
        }
    }
}

