/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.wrp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.internal.BootstrapContextImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengDialectFactory;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.reader.DatabaseReader;
import org.hibernate.tool.orm.jbt.wrp.Wrapper;

public class DatabaseReaderWrapperFactory {
    public static DatabaseReaderWrapper createDatabaseReaderWrapper(Properties properties, RevengStrategy revengStrategy) {
        return new DatabaseReaderWrapperImpl(properties, revengStrategy);
    }

    static class DatabaseReaderWrapperImpl
    implements DatabaseReaderWrapper {
        DatabaseReader databaseReader = null;
        RevengMetadataCollector revengMetadataCollector = null;

        public DatabaseReaderWrapperImpl(Properties properties, RevengStrategy revengStrategy) {
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(properties).build();
            MetadataBuilderImpl.MetadataBuildingOptionsImpl metadataBuildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(serviceRegistry);
            BootstrapContextImpl bootstrapContext = new BootstrapContextImpl(serviceRegistry, (MetadataBuildingOptions)metadataBuildingOptions);
            metadataBuildingOptions.setBootstrapContext((BootstrapContext)bootstrapContext);
            InFlightMetadataCollectorImpl metadataCollector = new InFlightMetadataCollectorImpl((BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions);
            RevengDialect mdd = RevengDialectFactory.createMetaDataDialect((Dialect)((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getDialect(), (Properties)properties);
            this.databaseReader = DatabaseReader.create((Properties)properties, (RevengStrategy)revengStrategy, (RevengDialect)mdd, (ServiceRegistry)serviceRegistry);
            MetadataBuildingContextRootImpl metadataBuildingContext = new MetadataBuildingContextRootImpl("JBoss Tools", (BootstrapContext)bootstrapContext, (MetadataBuildingOptions)metadataBuildingOptions, (InFlightMetadataCollector)metadataCollector);
            this.revengMetadataCollector = new RevengMetadataCollector((MetadataBuildingContext)metadataBuildingContext);
        }

        @Override
        public Map<String, List<Table>> collectDatabaseTables() {
            this.databaseReader.readDatabaseSchema(this.revengMetadataCollector);
            HashMap<String, List<Table>> result = new HashMap<String, List<Table>>();
            for (Table table : this.revengMetadataCollector.getTables()) {
                ArrayList<Table> list;
                Object qualifier = "";
                if (table.getCatalog() != null) {
                    qualifier = (String)qualifier + table.getCatalog();
                }
                if (table.getSchema() != null) {
                    if (!"".equals(qualifier)) {
                        qualifier = (String)qualifier + ".";
                    }
                    qualifier = (String)qualifier + table.getSchema();
                }
                if ((list = (ArrayList<Table>)result.get(qualifier)) == null) {
                    list = new ArrayList<Table>();
                    result.put((String)qualifier, list);
                }
                list.add(table);
            }
            return result;
        }
    }

    static interface DatabaseReaderWrapper
    extends Wrapper {
        public Map<String, List<Table>> collectDatabaseTables();
    }
}

