/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.orm.jbt.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;

public class MetadataHelper {
    public static Metadata getMetadata(Configuration configuration) {
        Metadata result = MetadataHelper.getMetadataFromMethod(configuration);
        if (result == null) {
            result = MetadataHelper.getMetadataFromField(configuration);
        }
        if (result == null) {
            result = MetadataHelper.buildFromMetadataSources(configuration);
        }
        return result;
    }

    public static MetadataSources getMetadataSources(Configuration configuration) {
        MetadataSources result = null;
        Field metadataSourcesField = MetadataHelper.getField("metadataSources", configuration);
        if (metadataSourcesField != null) {
            try {
                metadataSourcesField.setAccessible(true);
                result = (MetadataSources)metadataSourcesField.get(configuration);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        if (result == null) {
            result = new MetadataSources();
        }
        return result;
    }

    private static Metadata getMetadataFromMethod(Configuration configuration) {
        Metadata result = null;
        Method metadataMethod = MetadataHelper.getMethod("getMetadata", configuration);
        if (metadataMethod != null) {
            try {
                metadataMethod.setAccessible(true);
                result = (Metadata)metadataMethod.invoke((Object)configuration, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Method getMethod(String methodName, Object target) {
        Method result = null;
        Class<?> clazz = target.getClass();
        try {
            result = clazz.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return result;
    }

    private static Metadata getMetadataFromField(Configuration configuration) {
        Metadata result = null;
        Field metadataField = MetadataHelper.getField("metadata", configuration);
        if (metadataField != null) {
            try {
                metadataField.setAccessible(true);
                result = (Metadata)metadataField.get(configuration);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Field getField(String fieldName, Object target) {
        Field result = null;
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                result = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Metadata buildFromMetadataSources(Configuration configuration) {
        MetadataSources metadataSources = MetadataHelper.getMetadataSources(configuration);
        StandardServiceRegistryBuilder builder = configuration.getStandardServiceRegistryBuilder();
        builder.applySettings(configuration.getProperties());
        StandardServiceRegistry serviceRegistry = builder.build();
        return metadataSources.buildMetadata(serviceRegistry);
    }
}

