/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;
import org.hibernate.tool.util.StringUtil;

public class QueryExporterTask
extends ExporterTask {
    private String query = "";
    private String filename;
    List<HQL> queries = new ArrayList<HQL>();

    public QueryExporterTask(HibernateToolTask parent) {
        super(parent);
    }

    @Override
    protected Exporter configureExporter(Exporter exp) {
        Exporter exporter = super.configureExporter(exp);
        ArrayList<String> queryStrings = new ArrayList<String>();
        if (!StringUtil.isEmptyOrNull((String)this.query)) {
            queryStrings.add(this.query);
        }
        for (HQL hql : this.queries) {
            if (StringUtil.isEmptyOrNull((String)hql.query)) continue;
            queryStrings.add(hql.query);
        }
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.QueryList", queryStrings);
        exporter.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.OutputFileName", this.filename);
        return exporter;
    }

    @Override
    public void validateParameters() {
        super.validateParameters();
        if (StringUtil.isEmptyOrNull((String)this.query) && this.queries.isEmpty()) {
            throw new BuildException("Need to specify at least one query.");
        }
        for (HQL hql : this.queries) {
            if (!StringUtil.isEmptyOrNull((String)hql.query)) continue;
            throw new BuildException("Query must not be empty");
        }
    }

    @Override
    protected Exporter createExporter() {
        return ExporterFactory.createExporter((ExporterType)ExporterType.QUERY);
    }

    public void addText(String text) {
        if (!StringUtil.isEmptyOrNull((String)text)) {
            this.query = this.query + QueryExporterTask.trim(text);
        }
    }

    private static String trim(String text) {
        return text.trim();
    }

    public HQL createHql() {
        HQL hql = new HQL();
        this.queries.add(hql);
        return hql;
    }

    public void setDestFile(String filename) {
        this.filename = filename;
    }

    @Override
    public void execute() {
        this.parent.log("Executing: [" + this.query + "]");
        super.execute();
    }

    @Override
    public String getName() {
        return "query (Executes queries)";
    }

    boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static class HQL {
        String query = "";

        public void addText(String text) {
            if (!StringUtil.isEmptyOrNull((String)text)) {
                this.query = this.query + QueryExporterTask.trim(text);
            }
        }
    }
}

