/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;

public class GenericExporterTask
extends ExporterTask {
    String templateName;
    String exporterClass;
    String filePattern;
    String forEach;

    public GenericExporterTask(HibernateToolTask parent) {
        super(parent);
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setForEach(String forEach) {
        this.forEach = forEach;
    }

    public void setTemplate(String templateName) {
        this.templateName = templateName;
    }

    public void setExporterClass(String exporterClass) {
        this.exporterClass = exporterClass;
    }

    @Override
    protected Exporter createExporter() {
        if (this.exporterClass == null) {
            return ExporterFactory.createExporter((ExporterType)ExporterType.GENERIC);
        }
        return ExporterFactory.createExporter((String)this.exporterClass);
    }

    @Override
    protected Exporter configureExporter(Exporter exp) {
        super.configureExporter(exp);
        if (this.templateName != null) {
            exp.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplateName", this.templateName);
        }
        if (this.filePattern != null) {
            exp.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.FilePattern", this.filePattern);
        }
        if (this.forEach != null) {
            exp.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ForEach", this.forEach);
        }
        return exp;
    }

    @Override
    public String getName() {
        StringBuffer buf = new StringBuffer("generic exporter");
        if (this.exporterClass != null) {
            buf.append("class: " + this.exporterClass);
        }
        if (this.templateName != null) {
            buf.append("template: " + this.templateName);
        }
        return buf.toString();
    }
}

