/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import java.util.Collection;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorMultiNode<T>
extends PojoIndexingProcessor<T> {
    private final Collection<? extends PojoIndexingProcessor<? super T>> elements;

    public PojoIndexingProcessorMultiNode(Collection<? extends PojoIndexingProcessor<? super T>> elements) {
        this.elements = elements;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(PojoIndexingProcessor::close, this.elements);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.startList();
        for (PojoIndexingProcessor<? super T> pojoIndexingProcessor : this.elements) {
            builder.value(pojoIndexingProcessor);
        }
        builder.endList();
    }

    @Override
    public final void process(DocumentElement target, T source, PojoIndexingProcessorSessionContext sessionContext) {
        for (PojoIndexingProcessor<T> element : this.elements) {
            element.process(target, source, sessionContext);
        }
    }
}

