/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.typepattern.impl;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ArrayElementTypeMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ConstantExtractingTypePatternMatcherAdapter;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ExactRawTypeMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ExtractingTypePatternMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ParameterizedTypeArgumentMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.RawSuperTypeMatcher;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.TypePatternMatcher;
import org.hibernate.search.util.common.AssertionFailure;

public class TypePatternMatcherFactory {
    private final PojoBootstrapIntrospector introspector;

    public TypePatternMatcherFactory(PojoBootstrapIntrospector introspector) {
        this.introspector = introspector;
    }

    public TypePatternMatcher createExactRawTypeMatcher(Class<?> exactTypeToMatch) {
        PojoRawTypeModel<?> exactTypeToMatchModel = this.introspector.typeModel(exactTypeToMatch);
        return new ExactRawTypeMatcher(exactTypeToMatchModel);
    }

    public TypePatternMatcher createRawSuperTypeMatcher(Class<?> superTypeToMatch) {
        PojoRawTypeModel<?> superTypeToMatchModel = this.introspector.typeModel(superTypeToMatch);
        return new RawSuperTypeMatcher(superTypeToMatchModel);
    }

    public ExtractingTypePatternMatcher createExtractingMatcher(Type typePattern, Type typeToExtract) {
        if (typePattern instanceof TypeVariable) {
            throw new UnsupportedOperationException("Matching a type variable is not supported");
        }
        if (typePattern instanceof WildcardType) {
            throw new UnsupportedOperationException("Matching a wildcard type is not supported");
        }
        if (typePattern instanceof ParameterizedType) {
            ParameterizedType parameterizedTypePattern = (ParameterizedType)typePattern;
            return this.createExtractingParameterizedTypeMatcher(parameterizedTypePattern, typeToExtract);
        }
        if (typePattern instanceof Class) {
            Class classTypePattern = (Class)typePattern;
            return this.createExtractingClassTypeMatcher(classTypePattern, typeToExtract);
        }
        if (typePattern instanceof GenericArrayType) {
            GenericArrayType arrayTypePattern = (GenericArrayType)typePattern;
            return this.createExtractingGenericArrayTypeMatcher(arrayTypePattern, typeToExtract);
        }
        throw new AssertionFailure("Unexpected java.lang.reflect.Type type: " + typePattern.getClass());
    }

    private ExtractingTypePatternMatcher createExtractingGenericArrayTypeMatcher(GenericArrayType typePattern, Type typeToExtract) {
        if (!(typeToExtract instanceof TypeVariable) || !typePattern.getGenericComponentType().equals(typeToExtract)) {
            throw new UnsupportedOperationException("Extracting anything other than the array element type when matching array types is not supported");
        }
        TypeVariable resultTypeVariable = (TypeVariable)typeToExtract;
        Type[] upperBounds = resultTypeVariable.getBounds();
        if (upperBounds.length > 1 || !Object.class.equals((Object)upperBounds[0])) {
            throw new UnsupportedOperationException("Matching types with bounded type variables is not supported");
        }
        return new ArrayElementTypeMatcher();
    }

    private ExtractingTypePatternMatcher createExtractingClassTypeMatcher(Class<?> typePattern, Type typeToExtract) {
        if (!(typeToExtract instanceof Class)) {
            throw new UnsupportedOperationException("Extracting a non-raw result type when matching a raw type is not supported");
        }
        PojoRawTypeModel<?> typePatternModel = this.introspector.typeModel(typePattern);
        PojoGenericTypeModel typeToExtractModel = this.introspector.genericTypeModel((Class)typeToExtract);
        return new ConstantExtractingTypePatternMatcherAdapter(new RawSuperTypeMatcher(typePatternModel), typeToExtractModel);
    }

    private ExtractingTypePatternMatcher createExtractingParameterizedTypeMatcher(ParameterizedType typePattern, Type typeToExtract) {
        Class rawTypePattern = (Class)typePattern.getRawType();
        Type[] typeArguments = typePattern.getActualTypeArguments();
        Integer typeVariableIndex = null;
        for (int i = 0; i < typeArguments.length; ++i) {
            Type[] upperBounds;
            Type typeArgument = typeArguments[i];
            if (typeArgument instanceof TypeVariable) {
                if (typeVariableIndex == null) {
                    typeVariableIndex = i;
                    TypeVariable typeVariable = (TypeVariable)typeArgument;
                    upperBounds = typeVariable.getBounds();
                    if (!typeToExtract.equals(typeVariable)) {
                        throw new UnsupportedOperationException("Extracting anything other than the type variable when matching parameterized types is not supported");
                    }
                    if (upperBounds.length <= 1 && Object.class.equals((Object)upperBounds[0])) continue;
                    throw new UnsupportedOperationException("Matching a parameterized type with bounded type arguments is not supported");
                }
                throw new UnsupportedOperationException("Matching a parameterized type with multiple type variables in its arguments is not supported");
            }
            if (typeArgument instanceof WildcardType) {
                WildcardType wildcardTypeArgument = (WildcardType)typeArgument;
                upperBounds = wildcardTypeArgument.getUpperBounds();
                Type[] lowerBounds = wildcardTypeArgument.getLowerBounds();
                if (upperBounds.length <= 1 && Object.class.equals((Object)upperBounds[0]) && lowerBounds.length <= 0) continue;
                throw new UnsupportedOperationException("Matching a parameterized type with bounded type arguments is not supported");
            }
            throw new UnsupportedOperationException("Only type variables and wildcard types are supported as arguments to a parameterized type to match");
        }
        if (typeVariableIndex == null) {
            throw new UnsupportedOperationException("Matching a parameterized type without a type variable in its arguments is not supported");
        }
        return new ParameterizedTypeArgumentMatcher(rawTypePattern, typeVariableIndex);
    }
}

