/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultJavaUtilCalendarValueBridge
implements ValueBridge<Calendar, ZonedDateTime> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ZonedDateTime toIndexedValue(Calendar value, ValueBridgeToIndexedValueContext context) {
        if (value == null) {
            return null;
        }
        if (value instanceof GregorianCalendar) {
            return ((GregorianCalendar)value).toZonedDateTime();
        }
        return value.toInstant().atZone(ZoneId.of("UTC"));
    }

    @Override
    public Calendar fromIndexedValue(ZonedDateTime value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : DefaultJavaUtilCalendarValueBridge.from(value);
    }

    @Override
    public ZonedDateTime parse(String value) {
        return ParseUtils.parseZonedDateTime((String)value);
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }

    private static Calendar from(ZonedDateTime value) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(value.getZone()), Locale.getDefault());
        if (calendar instanceof GregorianCalendar) {
            calendar.setTimeInMillis(Math.addExact(Math.multiplyExact(value.toEpochSecond(), 1000L), (long)value.get(ChronoField.MILLI_OF_SECOND)));
        } else {
            calendar.setTime(Date.from(value.toInstant()));
        }
        return calendar;
    }
}

