/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmPathInterpreter;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathDefinition;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathDefinitionProvider;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;

public class HibernateOrmPathDefinitionProvider
implements PojoPathDefinitionProvider {
    private final PojoRawTypeModel<?> typeModel;
    private final PersistentClass persistentClass;
    private final List<String> propertyStringRepresentationByOrdinal;
    private final HibernateOrmPathInterpreter interpreter = new HibernateOrmPathInterpreter();

    public HibernateOrmPathDefinitionProvider(PojoRawTypeModel<?> typeModel, PersistentClass persistentClass) {
        this.typeModel = typeModel;
        this.persistentClass = persistentClass;
        this.propertyStringRepresentationByOrdinal = new ArrayList<String>();
        for (Property property : persistentClass.getPropertyClosure()) {
            this.propertyStringRepresentationByOrdinal.add(property.getName());
        }
    }

    public List<String> preDefinedOrdinals() {
        return this.propertyStringRepresentationByOrdinal;
    }

    public PojoPathDefinition interpretPath(PojoModelPathValueNode source) {
        return this.interpreter.interpretPath(this.typeModel, this.persistentClass, this.propertyStringRepresentationByOrdinal, source);
    }
}

