/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;

public final class HibernateSearchContextProviderService
implements Service,
AutoCloseable,
Supplier<HibernateOrmMapping> {
    private volatile HibernateOrmMapping mapping;

    public static HibernateSearchContextProviderService get(SessionFactoryImplementor sessionFactory) {
        return HibernateOrmUtils.getServiceOrFail((ServiceRegistry)sessionFactory.getServiceRegistry(), HibernateSearchContextProviderService.class);
    }

    @Override
    public void close() {
        if (this.mapping != null) {
            this.mapping.close();
        }
    }

    public void initialize(HibernateOrmMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public HibernateOrmMapping get() {
        if (this.mapping != null) {
            return this.mapping;
        }
        throw ((Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup())).hibernateSearchNotInitialized();
    }
}

