/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.util.common.impl.Futures;

class HibernateSearchSessionFactoryObserver
implements SessionFactoryObserver {
    private final CompletableFuture<?> contextFuture;
    private final CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture;
    private final CompletableFuture<?> sessionFactoryClosingFuture;

    HibernateSearchSessionFactoryObserver(CompletableFuture<?> contextFuture, CompletableFuture<SessionFactoryImplementor> sessionFactoryCreatedFuture, CompletableFuture<?> sessionFactoryClosingFuture) {
        this.contextFuture = contextFuture;
        this.sessionFactoryCreatedFuture = sessionFactoryCreatedFuture;
        this.sessionFactoryClosingFuture = sessionFactoryClosingFuture;
    }

    public synchronized void sessionFactoryCreated(SessionFactory factory) {
        SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)factory;
        this.sessionFactoryCreatedFuture.complete(sessionFactoryImplementor);
        if (this.contextFuture.isCompletedExceptionally()) {
            Futures.unwrappedExceptionJoin(this.contextFuture);
        }
    }

    public synchronized void sessionFactoryClosing(SessionFactory factory) {
        this.sessionFactoryClosingFuture.complete(null);
    }
}

