/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.bootstrap.impl;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import org.hibernate.resource.beans.container.spi.ExtendedBeanManager;
import org.hibernate.search.mapper.orm.spi.EnvironmentSynchronizer;

class ExtendedBeanManagerSynchronizer
implements EnvironmentSynchronizer,
ExtendedBeanManager.LifecycleListener {
    private final List<Runnable> environmentInitializedActions = new ArrayList<Runnable>();
    private final List<Runnable> environmentDestroyingActions = new ArrayList<Runnable>();

    ExtendedBeanManagerSynchronizer() {
    }

    @Override
    public void whenEnvironmentReady(Runnable action) {
        this.environmentInitializedActions.add(action);
    }

    @Override
    public void whenEnvironmentDestroying(Runnable action) {
        this.environmentDestroyingActions.add(action);
    }

    public void beanManagerInitialized(BeanManager beanManager) {
        for (Runnable action : this.environmentInitializedActions) {
            action.run();
        }
    }

    public void beforeBeanManagerDestroyed(BeanManager beanManager) {
        for (Runnable action : this.environmentDestroyingActions) {
            action.run();
        }
    }
}

