/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.reporting.spi;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.data.impl.InsertionOrder;
import org.hibernate.search.util.common.impl.ToStringStyle;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.util.common.reporting.EventContextElement;

public final class RootFailureCollector
implements FailureCollector {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    static final int FAILURE_LIMIT = 100;
    private final String process;
    private final NonRootFailureCollector delegate;
    private final AtomicInteger failureCount = new AtomicInteger();

    public RootFailureCollector(String process) {
        this.process = process;
        this.delegate = new NonRootFailureCollector(this);
    }

    public void checkNoFailure() {
        if (this.failureCount.get() > 0) {
            ArrayList<Throwable> failures = new ArrayList<Throwable>();
            ToStringStyle style = ToStringStyle.multilineIndentStructure((String)EngineEventContextMessages.INSTANCE.failureReportContextFailuresSeparator(), (String)EngineEventContextMessages.INSTANCE.failureReportContextIndent(), (String)EngineEventContextMessages.INSTANCE.failureReportFailuresBulletPoint(), (String)EngineEventContextMessages.INSTANCE.failureReportFailuresNoBulletPoint());
            ToStringTreeBuilder builder = new ToStringTreeBuilder(style);
            builder.startObject();
            if (this.failureCount.get() > 100) {
                builder.value((Object)log.collectedFailureLimitReached(this.process, 100, this.failureCount.get()));
            }
            if (this.delegate != null) {
                this.delegate.appendChildrenFailuresTo(failures, builder);
            }
            builder.endObject();
            throw log.collectedFailures(this.process, builder.toString(), failures);
        }
    }

    @Override
    public ContextualFailureCollector withContext(EventContext context) {
        return this.delegate.withContext(context);
    }

    @Override
    public ContextualFailureCollector withContext(EventContextElement contextElement) {
        return this.delegate.withContext(contextElement);
    }

    private boolean shouldAddFailure() {
        return this.failureCount.incrementAndGet() <= 100;
    }

    private static class NonRootFailureCollector
    implements FailureCollector {
        protected final RootFailureCollector root;
        private final InsertionOrder<EventContextElement> childrenInsertionOrder = new InsertionOrder();
        private final Map<InsertionOrder.Key<EventContextElement>, ContextualFailureCollectorImpl> children = new ConcurrentSkipListMap<InsertionOrder.Key<EventContextElement>, ContextualFailureCollectorImpl>();

        private NonRootFailureCollector(RootFailureCollector root) {
            this.root = root;
        }

        protected NonRootFailureCollector(NonRootFailureCollector parent) {
            this.root = parent.root;
        }

        @Override
        public ContextualFailureCollectorImpl withContext(EventContext context) {
            if (context == null) {
                return this.withDefaultContext();
            }
            List elements = context.elements();
            try {
                NonRootFailureCollector failureCollector = this;
                for (EventContextElement contextElement : elements) {
                    failureCollector = failureCollector.withContext(contextElement);
                }
                return (ContextualFailureCollectorImpl)failureCollector;
            }
            catch (RuntimeException e) {
                log.exceptionWhileCollectingFailure(e.getMessage(), e);
                return this.withDefaultContext();
            }
        }

        @Override
        public ContextualFailureCollectorImpl withContext(EventContextElement contextElement) {
            if (contextElement == null) {
                return this.withDefaultContext();
            }
            return this.children.computeIfAbsent((InsertionOrder.Key<EventContextElement>)this.childrenInsertionOrder.wrapKey((Object)contextElement), key -> new ContextualFailureCollectorImpl(this, (EventContextElement)key.get()));
        }

        ContextualFailureCollectorImpl withDefaultContext() {
            return this.withContext(EventContexts.defaultContext());
        }

        EventContext createEventContext(EventContextElement contextElement) {
            return EventContext.create((EventContextElement)contextElement, (EventContextElement[])new EventContextElement[0]);
        }

        final void appendChildrenFailuresTo(List<Throwable> failures, ToStringTreeBuilder builder) {
            for (ContextualFailureCollectorImpl child : this.children.values()) {
                if (!child.hasFailure()) continue;
                child.appendFailuresTo(failures, builder);
            }
        }

        final Collection<ContextualFailureCollectorImpl> children() {
            return this.children.values();
        }
    }

    private static class ContextualFailureCollectorImpl
    extends NonRootFailureCollector
    implements ContextualFailureCollector {
        private final NonRootFailureCollector parent;
        private final EventContextElement contextElement;
        private final Collection<Throwable> failures = new ConcurrentLinkedDeque<Throwable>();
        private final Collection<String> failureMessages = new ConcurrentLinkedDeque<String>();

        private ContextualFailureCollectorImpl(NonRootFailureCollector parent, EventContextElement contextElement) {
            super(parent);
            this.parent = parent;
            this.contextElement = contextElement;
        }

        @Override
        public boolean hasFailure() {
            if (!this.failureMessages.isEmpty()) {
                return true;
            }
            for (ContextualFailureCollectorImpl child : this.children()) {
                if (!child.hasFailure()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void add(Throwable t) {
            if (t instanceof SearchException) {
                SearchException e = (SearchException)t;
                ContextualFailureCollectorImpl failureCollector = this;
                EventContext eventContext = e.context();
                if (eventContext != null) {
                    failureCollector = failureCollector.withContext(e.context());
                }
                failureCollector.doAdd(e, e.messageWithoutContext());
            } else {
                this.doAdd(t, t.getMessage());
            }
        }

        @Override
        public void add(String failureMessage) {
            this.doAdd(null, failureMessage);
        }

        @Override
        ContextualFailureCollectorImpl withDefaultContext() {
            return this;
        }

        public EventContext eventContext() {
            return this.parent.createEventContext(this.contextElement);
        }

        @Override
        EventContext createEventContext(EventContextElement contextElement) {
            return this.eventContext().append(contextElement);
        }

        void appendFailuresTo(List<Throwable> failures, ToStringTreeBuilder builder) {
            builder.startObject(this.contextElement.render());
            failures.addAll(this.failures);
            if (!this.failureMessages.isEmpty()) {
                builder.attribute(EngineEventContextMessages.INSTANCE.failureReportFailures(), this.failureMessages);
            }
            this.appendChildrenFailuresTo(failures, builder);
            builder.endObject();
        }

        private void doAdd(Throwable failure, String failureMessage) {
            log.newCollectedFailure(this.root.process, this, failure);
            if (this.root.shouldAddFailure()) {
                this.failureMessages.add(failureMessage);
                if (failure != null) {
                    this.failures.add(failure);
                }
            }
        }
    }
}

