/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.EngineSettings;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.EngineSpiSettings;
import org.hibernate.search.engine.common.impl.IndexManagerBuildingStateHolder;
import org.hibernate.search.engine.common.impl.MappedIndexManagerFactoryImpl;
import org.hibernate.search.engine.common.impl.MappingBuildContextImpl;
import org.hibernate.search.engine.common.impl.RootBuildContext;
import org.hibernate.search.engine.common.impl.SearchIntegrationPartialBuildStateImpl;
import org.hibernate.search.engine.common.resources.impl.EngineThreads;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationEnvironment;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.common.timing.impl.DefaultTimingSource;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.thread.impl.ThreadPoolProviderImpl;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.BackendsInfo;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerFactory;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingAbortedException;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.mapper.model.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.mapper.model.spi.TypeMetadataDiscoverer;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.impl.FailSafeFailureHandlerWrapper;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.SuppressingCloser;

public class SearchIntegrationBuilder
implements SearchIntegration.Builder {
    private static final ConfigurationProperty<BeanReference<? extends FailureHandler>> BACKGROUND_FAILURE_HANDLER = ConfigurationProperty.forKey("background_failure_handler").asBeanReference(FailureHandler.class).withDefault(EngineSettings.Defaults.BACKGROUND_FAILURE_HANDLER).build();
    private static final ConfigurationProperty<BeanReference<? extends ThreadProvider>> THREAD_PROVIDER = ConfigurationProperty.forKey("thread_provider").asBeanReference(ThreadProvider.class).withDefault(EngineSpiSettings.Defaults.THREAD_PROVIDER).build();
    private final SearchIntegrationEnvironment environment;
    private final Map<MappingKey<?, ?>, MappingInitiator<?, ?>> mappingInitiators = new LinkedHashMap();
    private boolean frozen = false;

    public SearchIntegrationBuilder(SearchIntegrationEnvironment environment) {
        this.environment = environment;
        environment.propertyChecker().beforeBoot();
    }

    @Override
    public <PBM extends MappingPartialBuildState> SearchIntegration.Builder addMappingInitiator(MappingKey<PBM, ?> mappingKey, MappingInitiator<?, PBM> initiator) {
        if (this.frozen) {
            throw new AssertionFailure("Attempt to add a mapping initiator after Hibernate Search has started to build the mappings.");
        }
        MappingInitiator<?, PBM> existing = this.mappingInitiators.putIfAbsent(mappingKey, initiator);
        if (existing != null) {
            throw new AssertionFailure("Mapping key '" + mappingKey + "' has multiple initiators: '" + existing + "', '" + initiator + "'.");
        }
        return this;
    }

    @Override
    public SearchIntegrationPartialBuildState prepareBuild() {
        ConfigurationPropertySource propertySource = this.environment.propertySource();
        BeanResolver beanResolver = this.environment.beanResolver();
        BeanHolder<FailSafeFailureHandlerWrapper> failureHandlerHolder = null;
        BeanHolder threadProviderHolder = null;
        IndexManagerBuildingStateHolder indexManagerBuildingStateHolder = null;
        ArrayList<MappingBuildingState> mappingBuildingStates = new ArrayList<MappingBuildingState>();
        HashMap partiallyBuiltMappings = new HashMap();
        RootFailureCollector failureCollector = new RootFailureCollector(EngineEventContextMessages.INSTANCE.bootstrap());
        boolean checkingRootFailures = false;
        EngineThreads engineThreads = null;
        DefaultTimingSource timingSource = null;
        try {
            this.frozen = true;
            failureHandlerHolder = BACKGROUND_FAILURE_HANDLER.getAndTransform(propertySource, beanResolver::resolve);
            failureHandlerHolder = BeanHolder.of(new FailSafeFailureHandlerWrapper((FailureHandler)failureHandlerHolder.get())).withDependencyAutoClosing(failureHandlerHolder);
            FailureHandler failureHandler = failureHandlerHolder.get();
            threadProviderHolder = THREAD_PROVIDER.getAndTransform(propertySource, beanResolver::resolve);
            ThreadPoolProviderImpl threadPoolProvider = new ThreadPoolProviderImpl(threadProviderHolder);
            engineThreads = new EngineThreads(threadPoolProvider);
            timingSource = new DefaultTimingSource(engineThreads);
            RootBuildContext rootBuildContext = new RootBuildContext(propertySource, this.environment.classResolver(), this.environment.resourceResolver(), beanResolver, failureCollector, threadPoolProvider, failureHandler, engineThreads, timingSource);
            indexManagerBuildingStateHolder = new IndexManagerBuildingStateHolder(beanResolver, propertySource, rootBuildContext);
            for (Map.Entry<MappingKey<?, ?>, MappingInitiator<?, ?>> entry : this.mappingInitiators.entrySet()) {
                MappingBuildingState mappingBuildingState = new MappingBuildingState(rootBuildContext, entry.getKey(), entry.getValue());
                mappingBuildingStates.add(mappingBuildingState);
                mappingBuildingState.collect();
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.createMapper();
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            BackendsInfo backendsInfo = new BackendsInfo();
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.determineIndexedTypes(backendsInfo);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            indexManagerBuildingStateHolder.createBackends(backendsInfo);
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            MappedIndexManagerFactoryImpl mappedIndexManagerFactoryImpl = new MappedIndexManagerFactoryImpl(indexManagerBuildingStateHolder);
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.mapIndexedTypes(mappedIndexManagerFactoryImpl);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.partiallyBuildAndAddTo(partiallyBuiltMappings);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            return new SearchIntegrationPartialBuildStateImpl(this.environment.beanProvider(), beanResolver, failureHandlerHolder, threadPoolProvider, partiallyBuiltMappings, indexManagerBuildingStateHolder.getBackendNonStartedStates(), indexManagerBuildingStateHolder.getIndexManagersNonStartedStates(), this.environment.propertyChecker(), engineThreads, timingSource);
        }
        catch (RuntimeException e) {
            Throwable rethrownException;
            if (checkingRootFailures) {
                rethrownException = e;
            } else {
                try {
                    failureCollector.checkNoFailure();
                    rethrownException = e;
                }
                catch (SearchException e2) {
                    rethrownException = e2;
                    rethrownException.addSuppressed(e);
                }
            }
            SuppressingCloser closer = new SuppressingCloser(rethrownException);
            closer.push((AutoCloseable)failureHandlerHolder);
            closer.pushAll(MappingPartialBuildState::closeOnFailure, partiallyBuiltMappings.values());
            closer.pushAll(MappingBuildingState::closeOnFailure, mappingBuildingStates);
            closer.pushAll(holder -> holder.closeOnFailure(closer), (Object[])new IndexManagerBuildingStateHolder[]{indexManagerBuildingStateHolder});
            closer.pushAll(BeanHolder::close, (Object[])new BeanHolder[]{threadProviderHolder});
            closer.pushAll(SearchIntegrationEnvironment::close, (Object[])new SearchIntegrationEnvironment[]{this.environment});
            closer.push(EngineThreads::onStop, (Object)engineThreads);
            closer.push(TimingSource::stop, (Object)timingSource);
            throw rethrownException;
        }
    }

    private static class MappingBuildingState<C, PBM extends MappingPartialBuildState> {
        private final MappingBuildContext buildContext;
        private final MappingKey<PBM, ?> mappingKey;
        private final MappingInitiator<C, PBM> mappingInitiator;
        private TypeMetadataContributorProvider<C> metadataContributorProvider;
        private Mapper<PBM> mapper;

        MappingBuildingState(RootBuildContext rootBuildContext, MappingKey<PBM, ?> mappingKey, MappingInitiator<C, PBM> mappingInitiator) {
            this.mappingKey = mappingKey;
            this.buildContext = new MappingBuildContextImpl(rootBuildContext, mappingKey);
            this.mappingInitiator = mappingInitiator;
        }

        void collect() {
            TypeMetadataContributorProvider.Builder builder = TypeMetadataContributorProvider.builder();
            this.mappingInitiator.configure(this.buildContext, new MappingConfigurationCollectorImpl(builder));
            this.metadataContributorProvider = builder.build();
        }

        void createMapper() {
            this.mapper = this.mappingInitiator.createMapper(this.buildContext, this.metadataContributorProvider);
        }

        void determineIndexedTypes(BackendsInfo backendsInfo) {
            this.mapper.prepareIndexedTypes(backendsInfo);
        }

        void mapIndexedTypes(MappedIndexManagerFactory indexManagerFactory) {
            this.mapper.mapIndexedTypes(indexManagerFactory);
        }

        void partiallyBuildAndAddTo(Map<MappingKey<?, ?>, MappingPartialBuildState> mappings) {
            try {
                PBM partiallyBuiltMapping = this.mapper.prepareBuild();
                mappings.put(this.mappingKey, (MappingPartialBuildState)partiallyBuiltMapping);
            }
            catch (MappingAbortedException e) {
                this.handleMappingAborted(e);
            }
        }

        public void closeOnFailure() {
            if (this.mapper != null) {
                this.mapper.closeOnFailure();
            }
        }

        private void handleMappingAborted(MappingAbortedException e) {
            Throwable[] suppressed;
            ContextualFailureCollector failureCollector = this.buildContext.failureCollector();
            if (!failureCollector.hasFailure()) {
                throw new AssertionFailure("Caught " + MappingAbortedException.class.getSimpleName() + ", but the mapper did not collect any failure.", (Throwable)e);
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                failureCollector.add(cause);
            }
            for (Throwable throwable : suppressed = e.getSuppressed()) {
                failureCollector.add(throwable);
            }
        }

        private class MappingConfigurationCollectorImpl
        implements MappingConfigurationCollector<C> {
            private final TypeMetadataContributorProvider.Builder<C> builder;

            private MappingConfigurationCollectorImpl(TypeMetadataContributorProvider.Builder<C> builder) {
                this.builder = builder;
            }

            @Override
            public void collectContributor(MappableTypeModel typeModel, C contributor) {
                this.builder.contributor(typeModel, contributor);
            }

            @Override
            public void collectDiscoverer(TypeMetadataDiscoverer<C> metadataDiscoverer) {
                this.builder.discoverer(metadataDiscoverer);
            }
        }
    }
}

