/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.sort.impl;

import java.util.function.Function;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactory;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryExtension;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactoryExtensionIfSupportedMoreStep;
import org.hibernate.search.engine.search.dsl.sort.SortFinalStep;
import org.hibernate.search.engine.search.dsl.sort.SortThenStep;
import org.hibernate.search.engine.search.dsl.sort.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.dsl.sort.spi.StaticSortThenStep;

final class SearchSortFactoryExtensionStep<B>
implements SearchSortFactoryExtensionIfSupportedMoreStep {
    private final SearchSortFactory parent;
    private final SearchSortDslContext<?, B> dslContext;
    private final DslExtensionState<SortFinalStep> state = new DslExtensionState();

    SearchSortFactoryExtensionStep(SearchSortFactory parent, SearchSortDslContext<?, B> dslContext) {
        this.parent = parent;
        this.dslContext = dslContext;
    }

    @Override
    public <T> SearchSortFactoryExtensionIfSupportedMoreStep ifSupported(SearchSortFactoryExtension<T> extension, Function<T, ? extends SortFinalStep> sortContributor) {
        this.state.ifSupported(extension, extension.extendOptional(this.parent, this.dslContext), sortContributor);
        return this;
    }

    @Override
    public SortThenStep orElse(Function<SearchSortFactory, ? extends SortFinalStep> sortContributor) {
        SortFinalStep result = this.state.orElse(this.parent, sortContributor);
        return new StaticSortThenStep<B>(this.dslContext, this.dslContext.getBuilderFactory().toImplementation(result.toSort()));
    }

    @Override
    public SortThenStep orElseFail() {
        SortFinalStep result = this.state.orElseFail();
        return new StaticSortThenStep<B>(this.dslContext, this.dslContext.getBuilderFactory().toImplementation(result.toSort()));
    }
}

