/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.query.spi;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.engine.search.dsl.predicate.PredicateFinalStep;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.predicate.impl.DefaultSearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.query.SearchQueryOptionsStep;
import org.hibernate.search.engine.search.dsl.query.SearchQueryPredicateStep;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactory;
import org.hibernate.search.engine.search.dsl.sort.SortFinalStep;
import org.hibernate.search.engine.search.dsl.sort.impl.DefaultSearchSortFactory;
import org.hibernate.search.engine.search.dsl.sort.impl.SearchSortDslContextImpl;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;

public abstract class AbstractSearchQueryOptionsStep<S extends SearchQueryOptionsStep<S, H, SF>, H, PDF extends SearchPredicateFactory, SF extends SearchSortFactory, C>
implements SearchQueryPredicateStep<S, H, PDF>,
SearchQueryOptionsStep<S, H, SF> {
    private final IndexScope<C> indexScope;
    private final SearchQueryBuilder<H, C> searchQueryBuilder;

    public AbstractSearchQueryOptionsStep(IndexScope<C> indexScope, SearchQueryBuilder<H, C> searchQueryBuilder) {
        this.indexScope = indexScope;
        this.searchQueryBuilder = searchQueryBuilder;
    }

    @Override
    public S predicate(SearchPredicate predicate) {
        SearchPredicateBuilderFactory<C, ?> factory = this.indexScope.getSearchPredicateBuilderFactory();
        this.contribute(factory, predicate);
        return this.thisAsS();
    }

    @Override
    public S predicate(Function<? super PDF, ? extends PredicateFinalStep> predicateContributor) {
        SearchPredicateBuilderFactory<C, ?> builderFactory = this.indexScope.getSearchPredicateBuilderFactory();
        DefaultSearchPredicateFactory factory = new DefaultSearchPredicateFactory(builderFactory);
        SearchPredicate predicate = predicateContributor.apply(this.extendPredicateFactory(factory)).toPredicate();
        this.contribute(builderFactory, predicate);
        return this.thisAsS();
    }

    @Override
    public S routing(String routingKey) {
        this.searchQueryBuilder.addRoutingKey(routingKey);
        return this.thisAsS();
    }

    @Override
    public S routing(Collection<String> routingKeys) {
        routingKeys.forEach(this.searchQueryBuilder::addRoutingKey);
        return this.thisAsS();
    }

    @Override
    public S sort(SearchSort sort) {
        SearchSortBuilderFactory<C, ?> factory = this.indexScope.getSearchSortBuilderFactory();
        this.contribute(factory, sort);
        return this.thisAsS();
    }

    @Override
    public S sort(Function<? super SF, ? extends SortFinalStep> sortContributor) {
        SearchSortBuilderFactory<C, ?> builderFactory = this.indexScope.getSearchSortBuilderFactory();
        DefaultSearchSortFactory factory = new DefaultSearchSortFactory(SearchSortDslContextImpl.root(builderFactory));
        SearchSort sort = sortContributor.apply(this.extendSortFactory(factory)).toSort();
        this.contribute(builderFactory, sort);
        return this.thisAsS();
    }

    @Override
    public SearchQuery<H> toQuery() {
        return this.searchQueryBuilder.build();
    }

    @Override
    public SearchResult<H> fetch() {
        return this.toQuery().fetch();
    }

    @Override
    public SearchResult<H> fetch(Integer limit) {
        return this.toQuery().fetch(limit);
    }

    @Override
    public SearchResult<H> fetch(Integer limit, Integer offset) {
        return this.toQuery().fetch(limit, offset);
    }

    @Override
    public List<H> fetchHits() {
        return this.toQuery().fetchHits();
    }

    @Override
    public List<H> fetchHits(Integer limit) {
        return this.toQuery().fetchHits(limit);
    }

    @Override
    public List<H> fetchHits(Integer limit, Integer offset) {
        return this.toQuery().fetchHits(limit, offset);
    }

    @Override
    public Optional<H> fetchSingleHit() {
        return this.toQuery().fetchSingleHit();
    }

    @Override
    public long fetchTotalHitCount() {
        return this.toQuery().fetchTotalHitCount();
    }

    private <B> void contribute(SearchPredicateBuilderFactory<? super C, B> factory, SearchPredicate predicate) {
        factory.contribute(this.searchQueryBuilder.getQueryElementCollector(), factory.toImplementation(predicate));
    }

    private <B> void contribute(SearchSortBuilderFactory<? super C, B> factory, SearchSort sort) {
        factory.contribute(this.searchQueryBuilder.getQueryElementCollector(), factory.toImplementation(sort));
    }

    protected abstract S thisAsS();

    protected abstract PDF extendPredicateFactory(SearchPredicateFactory var1);

    protected abstract SF extendSortFactory(SearchSortFactory var1);
}

